package com.xforceplus.elephant.image.controller.compare.image.process;

import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.vaildate.Validator;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.GetImageStreamRequest;
import com.xforceplus.elephant.image.core.business.infrastructure.port.FileService;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import java.io.InputStream;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StreamUtils;

@Service
public class CompareGetImageStreamProcess implements Validator {

    private Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private CompareImageService imageService;
    @Autowired
    private FileService fileService;

    protected void check(Long imageId, GetImageStreamRequest request) throws ValidationException {
        if (imageId == null) {
            throw new ValidationException("主键不能为空");
        }
    }

    public ResponseEntity<byte[]> execute(Long imageId, GetImageStreamRequest request) {
        check(imageId, request);
        return process(imageId, request);
    }

    protected ResponseEntity<byte[]> process(Long imageId, GetImageStreamRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        final Image entity = imageService.selectOne(imageId);
        checkEmpty(entity, "影像不存在");
        String url = entity.getFileUrlLocal();
        if (ValidatorUtil.isEmpty(url)) {
            url = entity.getFileUrlHandle();
        }
        if (YesNo._1.getCode().equals(request.getIsMore())) {
            url = entity.getMoreFileUrl();
        }
        checkEmpty(url, "影像不存在");
        if (url.startsWith("http")) {
            try (InputStream is = HttpUtils.doGetInputStream(url)) {
                final byte[] bytes = StreamUtils.copyToByteArray(is);
                return ResponseEntity.ok()
                    //.header("Content-Disposition", "attachment;fileName=" + entity.getId() + entity.getFileTypeHandle())
                    .contentType(fileService.mediaType(entity.getFileTypeHandle()))
                    .contentLength(bytes.length).body(bytes);
            } catch (Exception e) {
                logger.error("下载失败", e);
            }
        } else {
            try (InputStream is = fileService.getFileInputStream(user.getTenantId(), user.getId(), url)) {
                final byte[] bytes = StreamUtils.copyToByteArray(is);
                return ResponseEntity.ok()
                    //.header("Content-Disposition", "attachment;fileName=" + entity.getId() + entity.getFileTypeHandle())
                    .contentType(fileService.mediaType(entity.getFileTypeHandle()))
                    .contentLength(bytes.length).body(bytes);
            } catch (Exception e) {
                logger.error("下载失败", e);
            }
        }
        return ResponseEntity.notFound().build();
    }

}