package com.xforceplus.elephant.image.controller.compare.image.process.insertimage;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.baseconst.ReleationConstants;
import com.xforceplus.elephant.basecommon.dispatch.BeanDispatcher;
import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.ImageInsertDTO;
import com.xforceplus.elephant.image.client.model.InsertImageRequest;
import com.xforceplus.elephant.image.common.CompareScanCommonService;
import com.xforceplus.elephant.image.core.business.application.collect.batch.domain.EnableFlowContext;
import com.xforceplus.elephant.image.core.business.application.collect.batch.service.BatchService;
import com.xforceplus.elephant.image.core.business.application.config.common.enums.ReceiveFilterEnums;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import com.xforceplus.elephant.image.core.business.util.LogUtil;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.elephant.image.core.domain.config.ConfigSettingsService;
import com.xforceplus.elephant.image.core.expand.bean.TicketRecogBean;
import com.xforceplus.elephant.image.core.expand.compare.CompareBillImageTicketService;
import com.xforceplus.elephant.image.core.facade.application.collect.bill.BillFacade;
import com.xforceplus.elephant.image.core.facade.application.compare.ticket.CompareTicketFacade;
import com.xforceplus.elephant.image.core.facade.application.config.dictionary.extfields.ExtFieldsReceiveFacade;
import com.xforceplus.elephant.image.core.repository.model.BatchTaskEntity;
import com.xforceplus.elephant.image.core.util.ImageUtils;
import com.xforceplus.purchaser.bizratelimiter.model.Application;
import com.xforceplus.purchaser.bizratelimiter.model.BizRequest;
import com.xforceplus.purchaser.bizratelimiter.model.Channel;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BackType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ExceptionStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.RecStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.SettlementType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.xlog.core.model.LogContext;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.groovy.util.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Dispatch(isDefault = true)
@Service
public class DefaultCompareInsertImageProcess extends AbstractProcess<InsertImageRequest, List<Long>> {

    @Autowired
    protected BeanDispatcher beanDispatcher;
    @Autowired
    private CompareImageService imageService;
    @Autowired
    private CompareBillImageTicketService billImageTicketService;
    @Autowired
    private MQUtils rabbitmqUtils;
    @Autowired
    private CompareTicketFacade compareTicketFacade;
    @Autowired
    private ExtFieldsReceiveFacade extFieldsReceiveFacade;
    @Autowired
    private BillFacade billFacade;
    @Autowired
    private ConfigSettingsService configSettingsService;
    @Autowired
    private BatchService batchService;
    @Autowired
    private CompareScanCommonService scanCommonService;
    @Autowired(required = false)
    private Application application;

    @Override
    protected void check(InsertImageRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getBillCode(), "单据CODE不能为空");
        checkEmpty(request.getEntities(), "操作对象不能为空");
        for (ImageInsertDTO entity : request.getEntities()) {
            checkEmpty(entity.getImageSource(), "来源不能为空");
            checkEmpty(entity.getFileUrl(), "原始文件路径不能为空");
            checkEmpty(entity.getFileUrlHandle(), "处理文件路径不能为空");
            checkEmpty(entity.getFileType(), "原始文件类型不能为空");
            checkEmpty(entity.getFileTypeHandle(), "处理文件类型不能为空");
            checkEmpty(entity.getIsPublic(), "是否公共上传不能为空");
        }
    }

    @Override
    protected CommonResponse<List<Long>> process(InsertImageRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        final BaseBill baseBill = billFacade.selectBaseBillByCode(user.getTenantId(), request.getBillCode(), EntityMeta.CompareBaseBill.code());
        checkEmpty(baseBill, "单据不存在");
        if (!Arrays.asList(BillDataStatus._0.getCode(), BillDataStatus._2.getCode(), BillDataStatus._6.getCode(), BillDataStatus._4.getCode())
                   .contains(baseBill.getBillDataStatus())) {
            return CommonResponse.failed("单据非待提交/暂挂起/已提交/已退回状态不可补扫上传影像");
        }
        Image image = null;
        if (request.getParentImageId() != null && request.getParentImageId() > 0) {
            image = imageService.selectOne(user.getTenantId(), request.getParentImageId());
        }
        final String batchNo = Long.toString(System.currentTimeMillis());
        final Image finalImage = image;
        final AtomicInteger index = new AtomicInteger();
        final List<JSONObject> images = request.getEntities().stream().map(dto -> {
            final Image entity = Image.fromOQSMap(BeanUtils.convertJSON(dto));
            //移动端进详情页采集，没有查询业务单，前端默认无法传此参数
            if (ValidatorUtil.isEmpty(entity.getIsPublic())) {
                entity.setIsPublic(baseBill.getIsPublic());
            }
            if (finalImage == null) {
                entity.setFileOrder(ImageUtils.sequence(baseBill.getImageCount() + index.incrementAndGet()));
            }
            entity.setBatchNo(batchNo);
            entity.setTenantId(user.getTenantId());
            //补扫的单据全部变更为附件 || AR结算单默认附件
            if (ValidatorUtil.isNotEmpty(entity.getBillCode()) || SettlementType.AR.getCode().equals(baseBill.getSettlementType())) {
                entity.setImageType(ImageType._99.getCode());
                entity.setRequireOcrFlag(YesNo._0.getCode());
                entity.setRecStatus(RecStatus._2.getCode());
            } else {
                entity.setRequireOcrFlag(YesNo._1.getCode());
                entity.setRecStatus(RecStatus._0.getCode());
            }
            entity.setBillCode(request.getBillCode());
            entity.setBillEntityCode(baseBill.getBillTypeCode());
            entity.setStatus(ImageStatus._1.getCode());
            entity.setIsManualUnhook(YesNo._0.getCode());
            entity.setExceptionStatus(ExceptionStatus._0.getCode());
            entity.setReturnStatus(BackType._0.getCode());
            entity.setFileUrlLocal(StringUtils.EMPTY);
            entity.setCreateUserCode(user.getUserCode());
            entity.setCreateUserId(user.getId());
            entity.setCreateUserName(user.getUsername());
            entity.setCreateTime(LocalDateTime.now());
            //处理扩展字段
            final JSONObject json = new JSONObject(entity.toOQSMap());
            if (ValidatorUtil.isNotEmpty(request.getExt())) {
                json.putAll(extFieldsReceiveFacade.getExtFields(user.getTenantId(), ReceiveFilterEnums.IMAGE, request.getExt()));
            }
            json.put(ReleationConstants.BILL_OTM_IMAGE_ID, baseBill.getId());
            return json;
        }).collect(Collectors.toList());
        final EnableFlowContext context = new EnableFlowContext().setTenantId(user.getTenantId()).setUserId(user.getId());
        final boolean flag = batchService.enable(context);
        LogContext.setLogPoint("enableFlow", flag);
        if (flag) {
            final String channelCode = batchService.getChannelCode(user.getTenantCode());
            final BatchTaskEntity batchTaskEntity = new BatchTaskEntity();
            batchTaskEntity.setTenantId(user.getTenantId());
            batchTaskEntity.setTenantCode(user.getTenantCode());
            batchTaskEntity.setCreateUserId(user.getId());
            batchTaskEntity.setCreateUserName(user.getUsername());
            batchTaskEntity.setCreateTime(new Date());
            batchTaskEntity.setTaskCount(request.getEntities().size());
            batchTaskEntity.setChannelCode(channelCode);
            final Long batchId = batchService.insert(batchTaskEntity);
            images.forEach(imageMap -> imageMap.put(EntityMeta.Image.BATCH_NO.code(), batchId));
            final Map<String, Object> headers = new HashMap<>();
            headers.put(com.xforceplus.elephant.image.core.business.consts.Constants.TENANT_CODE, user.getTenantCode());
            headers.put("batchNo", batchId);
            headers.put("userInfo", JSONObject.toJSONString(user));
            headers.put("channelCode", channelCode);
            headers.put("startTime", System.currentTimeMillis());
            final JSONObject message = new JSONObject();
            message.put("bill", baseBill);
            message.put("images", images);
            message.put("parentImage", image);
            try {
                if (batchService.sendEnableFlow(context)) {
                    final Channel channel = application.loadChannel(channelCode);
                    final BizRequest bizRequest = BizRequest.builder()
                                                            .bizQuantity(batchTaskEntity.getTaskCount())
                                                            .properties(headers)
                                                            .body(message.toJSONString())
                                                            .attrs(Maps.of("queueName", MQEnum.COMPARE_INSERT_BILL_SCAN_SYNC_QUEUE))
                                                            .build();
                    channel.flowInRateLimit(bizRequest);
                } else {
                    rabbitmqUtils.sendByDirectExchange(MQEnum.COMPARE_INSERT_BILL_SCAN_SYNC_QUEUE, message.toJSONString(), headers);
                }
            } catch (Exception e) {
                LogContext.setLogPoint("enableFlowError", e.getMessage());
                logger.error("使用限流异常", e);
                LogContext.setLogPoint("error", String.format("使用限流异常:%s", e.getMessage()));
                rabbitmqUtils.sendByDirectExchange(MQEnum.COMPARE_INSERT_BILL_SCAN_SYNC_QUEUE, message.toJSONString(), headers);
            } finally {
                LogUtil.attachSaveCount(CollectionUtils.size(request.getEntities()));
            }
            return CommonResponse.ok("成功");
        }
        final List<Long> imageIds = scanCommonService.insertBillScan(user, baseBill, image, images);
        LogUtil.attachSaveCount(CollectionUtils.size(request.getEntities()));
        return CommonResponse.ok("成功", imageIds);
    }

    /**
     * 创建单据
     *
     * @param attachImages attachImages
     */
    private void toAnnex(List<Image> attachImages) {
        if (ValidatorUtil.isEmpty(attachImages)) {
            return;
        }
        attachImages.forEach(image -> {
            //附件保存
            final TicketRecogBean bean = new TicketRecogBean();
            bean.setImageId(image.getId());
            bean.setTenantId(image.getTenantId());
            bean.setBatchNo(image.getBatchNo());
            bean.setIsPublic(image.getIsPublic());
            bean.setScanUserId(image.getCreateUserId());
            bean.setScanUserName(image.getCreateUserName());
            final JSONObject discern = new JSONObject();
            discern.put("bill_code", image.getBillCode());
            discern.put("bill_entity_code", image.getBillEntityCode());
            discern.put("bill_type_code", image.getBillEntityCode());
            discern.put("serial_number", image.getSerialNumber());
            discern.put("system_orig", image.getImageSource());
            discern.put("system_source", image.getImageSource());
            discern.put("create_user_code", image.getCreateUserCode());
            final Map<String, Object> data = new HashMap<>();
            data.put("entityCode", EntityMeta.CompareTicketAttachment.code());
            data.put("recogJson", discern);
            bean.setRecogList(Collections.singletonList(data));
            logger.info("发送附件，imageId:【{}】,单据号：【{}】，所属单据：【{}】", image.getId(), image.getBillCode(), image.getBillEntityCode());
            beanDispatcher.dispatch(image.getTenantId(), CompareBillImageTicketService.class).insertOrUpdateRecogInfo(bean);
        });
    }

    protected void afterSave(List<Image> images) {
        new Thread(() -> {
            if (ValidatorUtil.isEmpty(images)) {
                return;
            }
            images.forEach(entity ->
                beanDispatcher.dispatch(entity.getTenantId(), CompareBillImageTicketService.class)
                              .saveImageLocal(entity));
        }).start();
    }

}