package com.xforceplus.elephant.image.controller.compare.ticket.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.enums.ticket.TicketDataTypeEnum;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.GetTicketManyRequest;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.elephant.image.core.domain.compare.ticket.CompareTicketService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompareGetTicketManyProcess extends AbstractProcess<GetTicketManyRequest, JSONObject> {

    @Autowired
    private CompareTicketService ticketService;
    @Autowired
    private CompareImageService imageService;

    @Override
    protected void check(GetTicketManyRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getImageIds(), "验证的影像ID不能为空");
    }

    @Override
    protected CommonResponse<JSONObject> process(GetTicketManyRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final JSONObject result = new JSONObject();
        result.put("selectedNum", request.getImageIds().size());
        //附件
        final List<String> attachList = new ArrayList<>();
        final Map<Long, List<Image>> attachImageMap = imageService.selectTicketAttachmentAndSalesList(
            authorizedUser.getTenantId(), request.getImageIds()).stream()
            .collect(Collectors.groupingBy(Image::getTicketImageId));
        for (int i = 0; i < request.getImageIds().size(); i++) {
            final Long imageId = request.getImageIds().get(i);
            if (attachImageMap.containsKey(imageId)) {
                attachList.add(String.format("勾选发票%d下共有%d张附件", i + 1, attachImageMap.get(imageId).size()));
            }
        }
        result.put("attachList", attachList);
        //多票
        final List<Map<String, Object>> ticketManyEntities =
            ticketService.selectTicketByImageIdsAndCode(authorizedUser.getTenantId(), request.getImageIds(), EntityMeta.CompareTicketMany.code());
        if (ValidatorUtil.isEmpty(ticketManyEntities)) {
            result.put("manyNum", 0);
            return CommonResponse.ok("没有多票数据", result);
        }
        result.put("manyNum", ticketManyEntities.size());
        final List<Long> manyImageIds = ticketManyEntities.stream()
            .map(r -> Long.parseLong(String.valueOf(r.get("image_id"))))
            .distinct()
            .collect(Collectors.toList());
        final List<Ticket> ticketEntities = ticketService.selectBaseTicketByImageIds(authorizedUser.getTenantId(), manyImageIds);
        final Map<Long, List<Ticket>> imageTicketMap = ticketEntities.stream()
            .collect(Collectors.groupingBy(Ticket::getImageId));
        final List<String> manyList = imageTicketMap.entrySet().stream().map(entry -> {
            final Map<String, Integer> typeCount = new HashMap<>();
            entry.getValue().forEach(entity -> {
                if (!EntityMeta.CompareTicketMany.code().equals(entity.getTicketCode())) {
                    TicketDataTypeEnum dataTypeEnum = TicketDataTypeEnum.fromCode(entity.getTicketCode());
                    if (null == dataTypeEnum) {
                        dataTypeEnum = TicketDataTypeEnum.F_ATTACHMENT;
                    }
                    if (!typeCount.containsKey(dataTypeEnum.getName())) {
                        typeCount.put(dataTypeEnum.getName(), 0);
                    }
                    typeCount.put(dataTypeEnum.getName(), typeCount.get(dataTypeEnum.getName()) + 1);
                }
            });
            final List<String> countStr = typeCount.entrySet().stream()
                .map(tc -> String.format("%s(%s份)", tc.getKey(), tc.getValue()))
                .collect(Collectors.toList());
            return String.format("原多票影像包含%s", StringUtils.join(countStr, "，"));
        }).collect(Collectors.toList());
        result.put("manyList", manyList);
        return CommonResponse.ok("成功", result);
    }

}
