package com.xforceplus.elephant.image.controller.errorcode;

import com.xforceplus.elephant.image.core.facade.application.errorcode.ErrorCodeFacade;
import com.xforceplus.elephant.image.core.facade.dto.errorcode.ProjectApiDto;
import com.xforceplus.general.starter.errorcode.ErrorCode;
import com.xforceplus.general.starter.errorcode.ErrorCodeConfigRepository;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import java.util.List;
import java.util.Optional;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2022/6/28 17:05
 */
@Component
@RequiredArgsConstructor
public class LocalErrorCodeRepository implements ErrorCodeConfigRepository {

    private final ErrorCodeFacade errorCodeFacade;

    @Override
    public Optional<ErrorCode> getErrorCode(final HttpMethod httpMethod, final String requestPath, final String tenantCode, final String code) {

        final List<ProjectApiDto> projectApiDtos = errorCodeFacade.listProjectApiList(UserInfoHolder.get().getTenantCode());

        final Optional<ErrorCode> errorCode = projectApiDtos.stream().filter(dto -> HttpMethod.resolve(dto.getHttpMethod()) == httpMethod && StringUtils.equals(requestPath, dto.getPath()))
            .map(ProjectApiDto::getErrorCodes)
            .findAny()
            .map(dto ->
                dto
                    .stream()
                    .filter(e -> StringUtils.equals(e.getErrorCode(), code))
                    .findFirst()
                    .map(e -> new ErrorCode(code, e.getMessage()))

            ).orElseGet(Optional::empty);

        return errorCode;
    }

}
