package com.xforceplus.elephant.image.controller.noauth.process;

import com.xforceplus.elephant.basecommon.enums.image.ImageExceptionStatusEnum;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.GetImageListRequest;
import com.xforceplus.elephant.image.core.domain.image.bean.ImageSearchBean;
import com.xforceplus.elephant.image.core.facade.application.collect.image.ImageFacade;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.util.HashMap;
import java.util.Map;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

@RequiredArgsConstructor
@Service
public class NoAuthGetImageCountProcess extends AbstractProcess<GetImageListRequest, Map<String, Long>> {

    private final ImageFacade imageFacade;

    @Override
    protected void check(GetImageListRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getBillCode(), "单据CODE不能为空");
    }

    @Override
    protected CommonResponse<Map<String, Long>> process(GetImageListRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        //查询
        final Map<String, Long> result = new HashMap<>();
        final ImageSearchBean searchBean = new ImageSearchBean();
        searchBean.setTenantId(authorizedUser.getTenantId());
        searchBean.setBillCode(request.getBillCode());
        searchBean.setPageSize(1);
        final Long allCount = imageFacade.selectBillImagesByCustomTicketParams(searchBean, EntityMeta.Image.code()).getRowNum().longValue();
        result.put("all", allCount);
        searchBean.getTicketParams().clear();
        searchBean.setExceptionStatus(ImageExceptionStatusEnum.WARNING.getCode());
        final Long warningCount = imageFacade.selectBillImagesByCustomTicketParams(searchBean, EntityMeta.Image.code()).getRowNum().longValue();
        result.put("warning", warningCount);
        searchBean.getTicketParams().clear();
        searchBean.setExceptionStatus(ImageExceptionStatusEnum.ERROR.getCode());
        final Long errorCount = imageFacade.selectBillImagesByCustomTicketParams(searchBean, EntityMeta.Image.code()).getRowNum().longValue();
        result.put("error", errorCount);
        return CommonResponse.ok("成功", result);
    }

}
