package com.xforceplus.elephant.image.controller.ticket.process;

import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.GetVerifyTagRequest;
import com.xforceplus.elephant.image.core.facade.application.collect.ticket.TicketFacade;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

@Service
@RequiredArgsConstructor
public class GetVerifyTagProcess extends AbstractProcess<GetVerifyTagRequest, Boolean> {

    private final TicketFacade ticketFacade;

    @Override
    protected void check(GetVerifyTagRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getTicketId())) {
            throw new ValidationException("单证ID【ticketId】不能为空");
        }
    }

    @Override
    protected CommonResponse<Boolean> process(GetVerifyTagRequest request) throws RuntimeException {
        return CommonResponse.ok("", ticketFacade.getVerifyResultTag(request.getTicketId()));
    }

}