package com.xforceplus.elephant.image.controller.ticket.process;

import static com.xforceplus.elephant.image.core.business.consts.Constants.TENANT_CODE;

import com.google.common.collect.Maps;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.BatchTicketRequest;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import com.xforceplus.elephant.image.core.domain.operationlog.OperationLogService;
import com.xforceplus.elephant.image.core.facade.application.collect.ticket.TicketFacade;
import com.xforceplus.elephant.image.core.facade.base.BaseFacade;
import com.xforceplus.elephant.image.core.util.RequestBuilder;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.CheckSignStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.OperationEntity;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.OperationType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
@RequiredArgsConstructor
public class PDFVerifyPassProcess extends AbstractProcess<BatchTicketRequest, Integer> {

    private final BaseFacade baseFacade;
    private final MQUtils rabbitmqUtils;
    private final TicketFacade ticketFacade;
    private final OperationLogService operationLogService;

    @Override
    protected CommonResponse<Integer> process(BatchTicketRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();// 获取登录用户上下文
        if (null == user) {
            throw new ValidationException("获取用户信息为空，请重新登陆.");
        }
        //发送mq,校验单证异常预警信息
        final ConditionQueryRequest queryRequest = new RequestBuilder()
            .field(EntityMeta.Ticket.ID.code(), ConditionOp.in, request.getIds())
            .field(EntityMeta.Ticket.CHECK_SIGN_STATUS.code(), ConditionOp.eq, CheckSignStatus._2.getCode())
            .build();
        final String ticketCode = request.isCompare() ? EntityMeta.CompareTicket.code() : EntityMeta.Ticket.code();
        final List<Map<String, Object>> tickets = baseFacade.findByCondition(ticketCode, queryRequest).getRows();
        //发送验签
        final Integer result = ticketFacade.pdfVerifyPass(request.getIds());
        //重算异常
        final Map<String, Object> headers = new HashMap<>();
        headers.put(TENANT_CODE, user.getTenantCode());
        tickets.forEach(ticket -> {
            final Map<String, Object> paramMap = Maps.newHashMap();
            paramMap.put("ticketId", ticket.get(EntityMeta.Ticket.ID.code()));
            paramMap.put("ticketCode", ticket.get(EntityMeta.Ticket.TICKET_CODE.code()));
            paramMap.put("source", "验签通过后重算异常预警");
            if (request.isCompare()) {
                rabbitmqUtils.sendByDirectExchange(MQEnum.COMPARE_CHECK_TICKET_EXCE_WARN_QUEUE, paramMap, headers);
            } else {
                rabbitmqUtils.sendByDirectExchange(MQEnum.CHECK_TICKET_EXCE_WARN_QUEUE, paramMap, headers);
            }
        });
        final List<String> ids = tickets.stream().map(ticket -> String.valueOf(ticket.get(EntityMeta.Ticket.ID.code())))
            .collect(Collectors.toList());
        operationLogService.insertOperationLog(OperationEntity.TICKET.getCode(), StringUtils.join(ids, ","),
            OperationType.PDF_VERIFY_PASS.getCode(), user.getUsername(), "");
        return CommonResponse.ok("成功", result);
    }

}