package com.xforceplus.elephant.image.servicehandler;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.core.business.application.config.common.service.ConfigService;
import com.xforceplus.elephant.image.core.business.domain.repository.RepositoryFacade;
import com.xforceplus.elephant.image.core.business.enums.DictEnum;
import com.xforceplus.elephant.image.core.domain.config.ConfigSettingsService;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.elephant.image.core.domain.multipurpose.MultipurposeService;
import com.xforceplus.elephant.image.core.domain.ticket.TicketService;
import com.xforceplus.elephant.image.core.facade.application.config.dictionary.DictionaryFacade;
import com.xforceplus.elephant.image.core.util.CommonEntityServiceHandler;
import com.xforceplus.elephant.image.core.util.ImageOrgUtils;
import com.xforceplus.elephant.image.core.util.RequestParser;
import com.xforceplus.general.ultraman.store.UltramanDataStoreFacadeWrapper;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tech.base.core.dispatcher.anno.QueryHandler;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta.Ticket;
import com.xforceplus.ultraman.extensions.business.service.BusinessFacade;
import com.xforceplus.ultraman.extensions.business.service.QueryConfig;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.metadata.domain.vo.dto.FieldCondition;
import com.xforceplus.ultraman.metadata.domain.vo.dto.SubFieldCondition;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.helper.RequestBuilder;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.DataQueryProvider.QueryProviderType;
import com.xforceplus.ultraman.sdk.core.cmd.ConditionSearchCmd;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpFactory;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpQuery;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Slf4j
@Service
@RequiredArgsConstructor
public class NewTicketService extends CommonEntityServiceHandler {

    private final ImageService imageService;
    private final ImageOrgUtils imageOrgUtils;
    private final DictionaryFacade dictionaryFacade;
    private final ConfigSettingsService configSettingsService;
    private final UltramanDataStoreFacadeWrapper ultramanDataStoreFacadeWrapper;
    private final BusinessFacade businessFacade;
    private final RepositoryFacade repositoryFacade;
    private final MultipurposeService multipurposeService;
    private final ContextService contextService;
    private final ConfigService configService;
    protected TicketService ticketService;

    @QueryHandler(condition = "msg.getMetaData().get('codes').contains('ticket')")
    @Override
    public Either<String, Tuple2<Integer, List<Map<String, Object>>>> conditionSearch(final ConditionSearchCmd cmd) {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final StopWatch stopWatch = new StopWatch("单证查询");
        final RequestParser requestParser = RequestParser.parse(cmd.getConditionQueryRequest());
        String pageCode = cmd.getPageCode();
        if (ValidatorUtil.isEmpty(pageCode) && ValidatorUtil.isNotEmpty(requestParser.value("page_code"))) {
            pageCode = requestParser.value("page_code").get(0);
        }
        //JXCPX-1320 数据字典配置页面，租户开启组织查询
        if (dictionaryFacade.isOpenOrgQuery(pageCode, authorizedUser.getTenantId(), authorizedUser.getTenantCode())) {
            stopWatch.start("组织id查询");
            final Tuple2<Boolean, List<Long>> tuple = imageOrgUtils.getCurrentUserOrgIds(authorizedUser.getTenantId(), authorizedUser.getId());
            if (Boolean.FALSE.equals(tuple._1)) {
                final List<Long> orgIds = tuple._2;
                if (ValidatorUtil.isEmpty(orgIds)) {
                    return Either.right(new Tuple2<>(0, new ArrayList<>()));
                }
                requestParser.field(EntityMeta.Ticket.ORG_ID.code(), ConditionOp.in, orgIds);
            }
            stopWatch.stop();
        }
        //用户筛选的区域权限
        if (ValidatorUtil.isNotEmpty(requestParser.subValue("areas", EntityMeta.Ticket.ID.code()))) {
            final List<String> values = requestParser.subValue("areas", EntityMeta.Ticket.ID.code());
            requestParser.removeSubField("areas", EntityMeta.Ticket.ID.code());
            requestParser.field(EntityMeta.Ticket.AREA_ID.code(), ConditionOp.in, values);
        }
        if (ValidatorUtil.isNotEmpty(requestParser.subValue("area", EntityMeta.Ticket.ID.code()))) {
            final List<String> values = requestParser.subValue("area", EntityMeta.Ticket.ID.code());
            requestParser.removeSubField("area", EntityMeta.Ticket.ID.code());
            requestParser.field(EntityMeta.Ticket.AREA_ID.code(), ConditionOp.in, values);
        }
        //默认区域权限
        if (dictionaryFacade.isOpenAreaQuery(pageCode, authorizedUser.getTenantId(), authorizedUser.getTenantCode())) {
            stopWatch.start("组织id查询");
            final Tuple2<Boolean, List<Long>> tuple = imageOrgUtils.getCurrentUserOrgIds(authorizedUser.getTenantId(), authorizedUser.getId());
            if (Boolean.FALSE.equals(tuple._1)) {
                final List<Long> orgIds = tuple._2;
                if (ValidatorUtil.isEmpty(orgIds)) {
                    return Either.right(new Tuple2<>(0, new ArrayList<>()));
                }
                requestParser.field(EntityMeta.Ticket.AREA_ID.code(), ConditionOp.in, orgIds);
            }
            stopWatch.stop();
        }
        //一票多用租户需要余额大于0
        if ("todoImagePool".equals(pageCode)) {
            final String isMultipurposeTicket = configSettingsService.select(authorizedUser.getTenantId(), EntityMeta.ConfigSettings.IS_MULTIPURPOSE_TICKET.code(), String.class,
                YesNo._0.getCode());
            if (YesNo._1.getCode().equals(isMultipurposeTicket)) {
                requestParser.field(EntityMeta.Ticket.BALANCE_AMOUNT.code(), ConditionOp.ne, 0);
            }
        }

        if (multipurposeService.isMultipurposeEnabled(authorizedUser.getTenantId())) {
            if (!multipurposeService.isCopyTicketUseSelfBalanceAmount()) {
                //获取主票余额，需要这些字段 {@link MultipurposeService}中使用
                requestParser.addItem(EntityMeta.Ticket.BALANCE_AMOUNT.code(), Ticket.COPY_FLAG.code(), Ticket.MAIN_IMAGE_ID.code(), Ticket.IMAGE_ID.code());
            }
        }

        // 单证查询增加标签筛选功能
        final ConditionQueryRequest request = cmd.getConditionQueryRequest();
        final String labelKey = "all_system_labels";
        final List<FieldCondition> fields = request.getConditions().getFields();

        ConditionSearchCmd searchCmd = cmd;
        if (fields.stream().anyMatch(f -> StringUtils.equals(f.getCode(), labelKey))) {
            final List<String> labelIds = getConditionFieldValue(labelKey, cmd.getConditionQueryRequest());
            if (CollectionUtils.isNotEmpty(labelIds)) {
                final RequestBuilder builder = new RequestBuilder().pageNo(request.getPageNo()).pageSize(request.getPageSize());
                request.getSort().forEach(s -> builder.sort(s.getField(), s.getOrder()));
                fields.forEach(f -> {
                    if (StringUtils.equals(f.getCode(), labelKey)) {
                        final String mainSysLabelId = "systemLabel.id";
                        f.setCode(mainSysLabelId);
                        builder.field(mainSysLabelId, f.getOperation(), f.getValue());
                    } else {
                        builder.field(f.getCode(), f.getOperation(), f.getValue());
                    }
                });
                final ExpQuery qryRel1 = ExpFactory.createFrom(cmd.getConditionQueryRequest());
                final ExpQuery qryRel2 = ExpFactory.createFrom(builder.build());
                searchCmd = new ConditionSearchCmd(cmd.getBoId(), qryRel1.mergeOr(qryRel2), cmd.version(), pageCode);
            }
        }

        log.debug("Ticket二开查询条件:{}", JSON.toJSONString(searchCmd));
        stopWatch.start("OQS查询");
        final Either<String, Tuple2<Integer, List<Map<String, Object>>>> tuple2Either = conditionOrSearchSupport(searchCmd);
        if (tuple2Either.isLeft() || (tuple2Either.isRight() && tuple2Either.get()._1 == 0)) {
            stopWatch.stop();
            log.info("耗时：{}", stopWatch.prettyPrint());
            return tuple2Either;
        }
        stopWatch.stop();
        log.info("耗时：{}", stopWatch.prettyPrint());
        stopWatch.start("是否附件填充");
        final List<Long> imageIds = tuple2Either.get()._2.stream()
                                                         .filter(map -> ValidatorUtil.isNotEmpty(map.get("image_id")))
                                                         .filter(map -> Long.valueOf(map.get("image_id").toString()) > 0)
                                                         .map(map -> Long.valueOf(map.get("image_id").toString()))
                                                         .collect(Collectors.toList());
        Map<Long, List<Image>> imageEntityMap = Maps.newHashMap();
        Map<Long, Image> imageMap = Maps.newHashMap();
        if (ValidatorUtil.isNotEmpty(imageIds)) {
            imageMap = imageService.selectImages(authorizedUser.getTenantId(), imageIds)
                                   .stream().collect(Collectors.toMap(Image::getId, Function.identity(), (o1, o2) -> o2));
            imageEntityMap = imageService.selectTicketAttachmentAndSalesList(
                                             authorizedUser.getTenantId(), imageIds).stream().filter(image -> ValidatorUtil.isNotEmpty(image.getTicketImageId()))
                                         .collect(Collectors.groupingBy(Image::getTicketImageId));
        }
        final List<String> tenantCodes = configService.selectDict(0L, DictEnum.NEED_WRAPPER_URL_TENANT_CONFIG.getCode(), String.class);
        // 复制票余额读取主票信息
        final Map<Object, Object> mainTicketMap = multipurposeService.getMainTicket(tuple2Either.get()._2);
        for (final Map<String, Object> map : tuple2Either.get()._2) {
            if (ValidatorUtil.isNotEmpty(map.get("image_id"))) {
                final Long imageId = Long.valueOf(map.get("image_id").toString());
                if (ValidatorUtil.isNotEmpty(imageEntityMap.get(imageId))) {
                    map.put("is_attachment", true);
                } else {
                    map.put("is_attachment", false);
                }
                final Image image;
                if ((image = imageMap.get(imageId)) != null) {
                    String fileUrl = ApiV1Image.PATH + "/image/" + image.getId() + image.getFileTypeHandle() + "?rid=" + System.currentTimeMillis();
                    if (CollectionUtils.isNotEmpty(tenantCodes) && !CollectionUtils.containsAny(tenantCodes, authorizedUser.getTenantCode())
                        && !ImageType._3.getCode().equals(image.getImageType())) {
                        fileUrl = ValidatorUtil.isNotEmpty(image.getFileUrlLocal()) ? image.getFileUrlLocal() : image.getFileUrlHandle();
                    }
                    map.put("imageUrl", fileUrl);
                }
                // 添加主票金额到复制票上（华住挂接优化，减少复制票操作次数）
                final Object mainTicketAmount = mainTicketMap.get(imageId);
                if (ValidatorUtil.isNotEmpty(mainTicketAmount)) {
                    map.put(EntityMeta.Ticket.BALANCE_AMOUNT.code(), mainTicketAmount);
                }
            } else {
                map.put("is_attachment", false);
            }
        }
        stopWatch.stop();
        log.info("耗时：{}", stopWatch.prettyPrint());
        return tuple2Either;
    }

    public Either<String, Tuple2<Integer, List<Map<String, Object>>>> conditionOrSearchSupport(final ConditionSearchCmd cmd) {
        try {
            final RequestParser requestParser = RequestParser.parse(cmd.getConditionQueryRequest());
            requestParser.removeField("page_code");

            // 校验是否存在imageOTMTicket关联对象查询,存在查询数据库
            if (checkRelationImageObj("imageOTMTicket", cmd.getConditionQueryRequest())) {
                return conditionOrSearchSupportRelationObj(cmd);
            }

            final Optional<IEntityClass> entityClassOp = this.getEntityClass(cmd);
            if (entityClassOp.isPresent()) {
                if (cmd.isUseTree()) {
                    final Long count = ultramanDataStoreFacadeWrapper.countExplicitly(UserInfoHolder.get().getTenantCode(),
                        entityClassOp.get(), (ExpQuery) cmd.getTree(), QueryConfig.builder().queryProviderType(QueryProviderType.INDEX).build());
                    final List<Map<String, Object>> list = ultramanDataStoreFacadeWrapper.findByConditionMapExplicitly(UserInfoHolder.get().getTenantCode(),
                        entityClassOp.get(), (ExpQuery) cmd.getTree(), QueryConfig.builder().queryProviderType(QueryProviderType.INDEX).build());
                    return Either.right(Tuple.of(count.intValue(), list));
                } else {
                    final ConditionQueryRequest request = cmd.getConditionQueryRequest();
                    final Long count = ultramanDataStoreFacadeWrapper.countExplicitly(UserInfoHolder.get().getTenantCode(),
                        entityClassOp.get(), request, QueryConfig.builder().queryProviderType(QueryProviderType.INDEX).build());
                    final List<Map<String, Object>> list = ultramanDataStoreFacadeWrapper.findByConditionMapExplicitly(UserInfoHolder.get().getTenantCode(),
                        entityClassOp.get(), request, QueryConfig.builder().queryProviderType(QueryProviderType.INDEX).build());
                    return Either.right(Tuple.of(count.intValue(), list));
                }
            } else {
                return Either.left("查询对象不存在");
            }
        } catch (final Exception var5) {
            log.error("ConditionSearch Error ", var5);
            return Either.left(var5.getMessage());
        }
    }

    private boolean checkRelationImageObj(final String relationObj, final ConditionQueryRequest queryRequest) {
        if (Objects.isNull(queryRequest) || Objects.isNull(queryRequest.getConditions())) {
            return false;
        }
        final List<SubFieldCondition> relationObjs = queryRequest.getConditions().getEntities();
        if (CollectionUtils.isEmpty(relationObjs)) {
            return false;
        }
        return relationObjs.stream().anyMatch(field -> relationObj.equals(field.getCode()));
    }

    public Either<String, Tuple2<Integer, List<Map<String, Object>>>> conditionOrSearchSupportRelationObj(final ConditionSearchCmd cmd) {
        try {
            final Optional<IEntityClass> entityClassOp = this.getEntityClass(cmd);
            if (entityClassOp.isPresent()) {
                if (cmd.isUseTree()) {
                    final Long count = ultramanDataStoreFacadeWrapper.count(UserInfoHolder.get().getTenantCode(),
                        entityClassOp.get(), (ExpQuery) cmd.getTree());
                    final List<Map<String, Object>> list = ultramanDataStoreFacadeWrapper.findByConditionMap(UserInfoHolder.get().getTenantCode(),
                        entityClassOp.get(), (ExpQuery) cmd.getTree());
                    return Either.right(Tuple.of(count.intValue(), list));
                } else {
                    final ConditionQueryRequest request = cmd.getConditionQueryRequest();
                    final Long count = ultramanDataStoreFacadeWrapper.count(UserInfoHolder.get().getTenantCode(),
                        entityClassOp.get(), request);
                    final List<Map<String, Object>> list = ultramanDataStoreFacadeWrapper.findByConditionMap(UserInfoHolder.get().getTenantCode(),
                        entityClassOp.get(), request);
                    return Either.right(Tuple.of(count.intValue(), list));
                }
            } else {
                return Either.left("查询对象不存在");
            }
        } catch (final Exception var5) {
            log.error("conditionOrSearchSupportRelationObj Error ", var5);
            return Either.left(var5.getMessage());
        }
    }

    private List<String> getConditionFieldValue(final String fieldKey, final ConditionQueryRequest queryRequest) {
        final Map<String, List<String>> filedMap = queryRequest.getConditions().getFields().stream().collect(Collectors.toMap(FieldCondition::getCode, FieldCondition::getValue));
        return filedMap.getOrDefault(fieldKey, null);
    }

}