package com.xforceplus.elephant.image.config;

import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import org.springdoc.core.GroupedOpenApi;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created by fanguozhu on 2017/8/2.
 */
@Configuration
public class SpringFoxConfiguration {

    public static final String AUTHORIZATION = "xforce-saas-token";
    public static final String TITLE = "image-service-saas API";

    @Bean
    public OpenAPI springShopOpenAPI() {
        return new OpenAPI()
            .info(new Info().title(TITLE).description("image-service-saas application").version("v0.0.1").license(new License().name("Apache 2.0").url("http://springdoc.org")))
            .externalDocs(new ExternalDocumentation().description("image-service-saas Documentation").url("http://www.xforceplus.com"))
            .schemaRequirement(AUTHORIZATION, this.securityScheme())
            .addSecurityItem(new SecurityRequirement().addList(AUTHORIZATION));
    }

    private SecurityScheme securityScheme() {
        final SecurityScheme securityScheme = new SecurityScheme();
        securityScheme.setType(SecurityScheme.Type.APIKEY);
        securityScheme.setName(AUTHORIZATION);
        securityScheme.setIn(SecurityScheme.In.HEADER);
        return securityScheme;
    }

    @Bean
    public GroupedOpenApi publicApi() {
        return GroupedOpenApi.builder()
            .group(TITLE)
            .pathsToMatch("/**")
            .build();
    }

}
