package com.xforceplus.elephant.image.controller.billdata.process.hookticket;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.help.RedisUtils;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.HookTicketObj;
import com.xforceplus.elephant.image.client.model.HookTicketRequest;
import com.xforceplus.elephant.image.core.business.application.config.common.enums.ReceiveFilterEnums;
import com.xforceplus.elephant.image.core.business.enums.ResourceEnum;
import com.xforceplus.elephant.image.core.business.util.LogUtil;
import com.xforceplus.elephant.image.core.domain.bill.BaseBillService;
import com.xforceplus.elephant.image.core.domain.config.ConfigSettingsService;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.elephant.image.core.domain.ticket.TicketService;
import com.xforceplus.elephant.image.core.expand.BillImageTicketService;
import com.xforceplus.elephant.image.core.expand.bean.HookTicketBean;
import com.xforceplus.elephant.image.core.facade.application.auth.DataResourceFacade;
import com.xforceplus.elephant.image.core.facade.application.config.dictionary.extfields.ExtFieldsReceiveFacade;
import com.xforceplus.elephant.image.mapper.HookTicketMapper;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Dispatch(isDefault = true)
@Service
public class DefaultHookTicketProcess extends AbstractProcess<HookTicketRequest, Boolean> {

    @Autowired
    protected RedisUtils redisUtils;
    @Autowired
    private BaseBillService baseBillService;
    @Autowired
    private BillImageTicketService billImageTicketService;
    @Autowired
    private TicketService ticketService;
    @Autowired
    private DataResourceFacade dataResourceFacade;
    @Autowired
    private ConfigSettingsService configSettingsService;
    @Autowired
    private HookTicketMapper hookTicketMapper;
    @Autowired
    private ExtFieldsReceiveFacade extFieldsReceiveFacade;
    @Autowired
    private ImageService imageService;

    @Override
    protected void check(final HookTicketRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getBillCode(), "单证code不能为空");
        checkEmpty(request.getHookTicketObjList(), "单证的影像不能为空");
        request.getHookTicketObjList().forEach(hookTicketObj -> {
            checkEmpty(hookTicketObj.getImageId(), "imageId不能为空");
            checkEmpty(hookTicketObj.getUsedAmount(), "占用金额不能为空");
        });

    }

    @Override
    protected CommonResponse<Boolean> process(final HookTicketRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        final Long tenantId = authorizedUser.getTenantId();
        final BaseBill billEntity = baseBillService.selectBaseBillByCode(authorizedUser.getTenantId(), request.getBillCode());
        if (ValidatorUtil.isEmpty(billEntity)) {
            return CommonResponse.failed("单据对象不存在");
        }
        if (billEntity != null && Arrays.asList(BillDataStatus._3.getCode(), BillDataStatus._1.getCode(), BillDataStatus._5.getCode())
                                        .contains(billEntity.getBillDataStatus())) {
            throw new ValidationException("单据已锁定/已作废/已完成状态不可挂接影像");
        }
        if (!dataResourceFacade.existBillDetailResourceAuth(authorizedUser.getTenantId(), request.getPageCode(), request.getScene(), billEntity, ResourceEnum.BILL_DETAILS_HOOK.getCode())) {
            throw new ValidationException("没有操作权限");
        }
        final List<HookTicketObj> hookTicketObjList = request.getHookTicketObjList();
        final Map<Long, BigDecimal> hookTicketImageIdMap = hookTicketObjList.stream().collect(Collectors.toMap(HookTicketObj::getImageId, HookTicketObj::getUsedAmount));
        final List<Long> imageIdList = hookTicketObjList.stream().map(HookTicketObj::getImageId).collect(Collectors.toList());
        final String isMultipurposeTicket = configSettingsService.select(tenantId, EntityMeta.ConfigSettings.IS_MULTIPURPOSE_TICKET.code(), String.class, YesNo._0.getCode());
        LogUtil.attachIsMultiPurposeTicket(YesNo._1.getCode().equals(isMultipurposeTicket));
        if (YesNo._0.getCode().equals(isMultipurposeTicket)) {
            final List<Long> imageIds = billImageTicketService.manualHookImages(authorizedUser.getTenantId(), request.getBillCode(),
                request.getParentImageId(), imageIdList);
            if (ValidatorUtil.isNotEmpty(imageIds)) {
                //JXCPX-1109 中南集团#功能优化#待办扫描页面认领发票时需要支持单证扩展字段更新
                if (ValidatorUtil.isNotEmpty(request.getExt())) {
                    final JSONObject update = extFieldsReceiveFacade.getExtFields(authorizedUser.getTenantId(), ReceiveFilterEnums.IMAGE, request.getExt());
                    imageIds.forEach(imageId -> imageService.updateByParam(imageId, update));
                }
                //改为异步后，需要更新单证业务单号、是否挂接
                ticketService.updateBaseTicketBillCodeByImageIds(imageIds, authorizedUser.getTenantId(), request.getBillCode(), billEntity);
                //影像挂接后更新单证新增标识
                ticketService.handleTicketIsAddFlag(imageIds, authorizedUser.getTenantId(), billEntity);
                //挂接成功，更新层级
                billImageTicketService.resetLevel(authorizedUser.getTenantId(), request.getBillCode());
                //修改单据状态为待处理
                if (BillDataStatus.fromCode(billEntity.getBillDataStatus()) == BillDataStatus._6) {
                    final JSONObject update = new JSONObject();
                    update.put(EntityMeta.BaseBill.BILL_DATA_STATUS.code(), BillDataStatus._0.getCode());
                    baseBillService.updateByBillIdSelective(billEntity.getId(), update);
                }
                return CommonResponse.ok("选择发票成功", true);
            }
        } else {
            final List<Map<String, Object>> mapList = ticketService.selectTicketByImageIds(tenantId, imageIdList);
            //校验金额
            for (final Map<String, Object> ticketMap : mapList) {
                if (hookTicketImageIdMap.containsKey(Long.valueOf(ticketMap.get(EntityMeta.Ticket.IMAGE_ID.code()).toString()))
                    && ValidatorUtil.isNotEmpty(hookTicketImageIdMap.get(Long.valueOf(ticketMap.get(EntityMeta.Ticket.IMAGE_ID.code()).toString())))
                    && hookTicketImageIdMap.get(Long.valueOf(ticketMap.get(EntityMeta.Ticket.IMAGE_ID.code()).toString()))
                                           .compareTo(getBigDecimal(ticketMap.get(EntityMeta.Ticket.BALANCE_AMOUNT.code()))) == 1) {
                    return CommonResponse.failed("选择发票失败,修改的个人可提报金额大于余额！");
                }
            }
            //校验同单重复
            final List<String> invoiceNoCodesList = mapList.stream()
                                                           .filter(map -> EntityMeta.TicketInvoice.code().equals(map.get(EntityMeta.Ticket.TICKET_CODE.code())))
                                                           .filter(map -> ValidatorUtil.isNotEmpty(map.get(EntityMeta.Ticket.INVOICE_NO.code())))
                                                           .filter(map -> ValidatorUtil.isNotEmpty(map.get(EntityMeta.Ticket.INVOICE_CODE.code())))
                                                           .map(map -> StringHelp.safeToString(map.get(EntityMeta.Ticket.INVOICE_NO.code())) + StringHelp.safeToString(
                                                               map.get(EntityMeta.Ticket.INVOICE_CODE.code())))
                                                           .collect(Collectors.toList());
            final List<Ticket> ticketList = ticketService.selectBaseTicketByBillCode(tenantId, request.getBillCode());
            for (final Ticket ticket : ticketList) {
                if (invoiceNoCodesList.contains(StringHelp.safeToString(ticket.getInvoiceNo()) + StringHelp.safeToString(ticket.getInvoiceCode()))) {
                    return CommonResponse.failed("选择发票失败,该单据已存在相同的发票号码" + ticket.getInvoiceNo() + ",发票代码:" + ticket.getInvoiceCode());
                }
            }
            final List<HookTicketBean> hookTicketBeanList = hookTicketMapper.map(hookTicketObjList);
            /*
            final List<Long> imageIds = billImageTicketService.manualHookImagesAmount(authorizedUser.getTenantId(),request.getBillCode(), request.getParentImageId(), hookTicketBeanList);
            */
            final List<Long> imageIds = billImageTicketService
                .manualHookImagesTicket(authorizedUser.getTenantId(), request.getBillCode(), request.getParentImageId(), hookTicketBeanList, billEntity);
            if (ValidatorUtil.isNotEmpty(imageIds)) {
                //JXCPX-1109 中南集团#功能优化#待办扫描页面认领发票时需要支持单证扩展字段更新
                if (ValidatorUtil.isNotEmpty(request.getExt())) {
                    final JSONObject update = extFieldsReceiveFacade.getExtFields(authorizedUser.getTenantId(), ReceiveFilterEnums.IMAGE, request.getExt());
                    imageIds.forEach(imageId -> imageService.updateByParam(imageId, update));
                }
                //改为异步后，需要更新单证业务单号、是否挂接
                //影像挂接后更新单证新增标识
                ticketService.handleTicketIsAddFlag(imageIds, authorizedUser.getTenantId(), billEntity);
                //挂接成功，更新层级
                billImageTicketService.resetLevel(authorizedUser.getTenantId(), request.getBillCode());
                //修改单据状态为待处理
                if (BillDataStatus.fromCode(billEntity.getBillDataStatus()) == BillDataStatus._6) {
                    final JSONObject update = new JSONObject();
                    update.put(EntityMeta.BaseBill.BILL_DATA_STATUS.code(), BillDataStatus._0.getCode());
                    baseBillService.updateByBillIdSelective(billEntity.getId(), update);
                }
                return CommonResponse.ok("选择发票成功", true);
            }

        }
        return CommonResponse.failed("选择发票失败");
    }

    private BigDecimal getBigDecimal(final Object value) {
        BigDecimal ret = null;
        if (value != null) {
            if (value instanceof BigDecimal) {
                ret = (BigDecimal) value;
            } else if (value instanceof String) {
                ret = new BigDecimal((String) value);
            } else if (value instanceof BigInteger) {
                ret = new BigDecimal((BigInteger) value);
            } else if (value instanceof Number) {
                ret = BigDecimal.valueOf(((Number) value).doubleValue());
            } else {
                ret = BigDecimal.ZERO;
            }
        }
        return ret;
    }

}
