package com.xforceplus.elephant.image.controller.common.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.core.business.consts.SettingProperties;
import com.xforceplus.general.utils.json.JsonUtil;
import java.util.List;
import javax.validation.ValidationException;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetConfigMenuProcess extends AbstractProcess<BaseRequest, Object> {

    @Autowired
    private SettingProperties settingProperties;

    @Override
    protected void check(BaseRequest request) throws ValidationException {
    }

    @Override
    protected CommonResponse<Object> process(BaseRequest request) throws RuntimeException {
        final List<JSONObject> jsonArray = JsonUtil.parseArray(settingProperties.getMenu(), JSONObject.class);
        if (CollectionUtils.isEmpty(jsonArray)) {
            return CommonResponse.failed("菜单数据模板格式有误");
        }
        return CommonResponse.ok("成功", jsonArray);
    }

}
