package com.xforceplus.elephant.image.controller.compare.billdata.process;

import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.HangBillRequest;
import com.xforceplus.elephant.image.core.domain.compare.bill.CompareBaseBillService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompareHangBillDataProcess extends AbstractProcess<HangBillRequest, Integer> {

    @Autowired
    private CompareBaseBillService baseBillService;

    @Override
    protected void check(HangBillRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getBillCodes(), "billCodes不能为空!");
    }

    @Override
    protected CommonResponse<Integer> process(HangBillRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }

        final int count = baseBillService.hangBill(authorizedUser.getTenantId(), request.getBillCodes(), request.getHangType(), request.getHangReason());
        return CommonResponse.ok("成功", count);
    }

}
