package com.xforceplus.elephant.image.controller.compare.billdata.process;

import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.BaseBillCommitRequest;
import com.xforceplus.elephant.image.client.model.EntityObj;
import com.xforceplus.elephant.image.core.domain.bill.BaseBillService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 默认稽核单据提交process类
 *
 * @author liming
 * @date 2021/8/20 13:54
 */
@Service
public class ComparePreCheckBillProcess extends AbstractProcess<BaseBillCommitRequest, String> {

    @Autowired
    private BaseBillService baseBillService;

    @Override
    protected void check(BaseBillCommitRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getEntities(), "entities不能为空");
    }

    @Override
    protected CommonResponse<String> process(BaseBillCommitRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();// 获取登录用户上下文
        if (null == user) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final List<String> billCodes = request.getEntities().stream().map(EntityObj::getBillCode).collect(Collectors.toList());
        final List<BaseBill> bills = baseBillService.selectBillDataByBillCodes(user.getTenantId(), billCodes);
        final List<String> tipBillCodes = bills.stream()
            .filter(bill -> BillDataStatus._4.getCode().equals(bill.getBillDataStatus()) || BillDataStatus._5.getCode().equals(bill.getBillDataStatus()))
            .map(bill -> bill.getBillCode())
            .collect(Collectors.toList());
        if (tipBillCodes == null || tipBillCodes.isEmpty()) {
            return CommonResponse.ok("成功", "");
        }
        final String result = String.format("当前提交的数据中含已退回或者已作废状态的单据%s，不建议您发起稽核，请确认是否强制提交稽核。", StringUtils.join(tipBillCodes, ","));
        return CommonResponse.ok("成功", result);
    }

}
