package com.xforceplus.elephant.image.controller.compare.billdata.process;

import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.UpdateReceiveStatusRequest;
import com.xforceplus.elephant.image.core.business.application.collect.bill.service.BillService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ReceiveStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Slf4j
@RequiredArgsConstructor
@Service
public class CompareUpdateReceiveStatusProcess extends AbstractProcess<UpdateReceiveStatusRequest, Boolean> {

    private final BillService billService;

    @Override
    protected void check(UpdateReceiveStatusRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getBillCodes(), "单据不能为空");
        checkEmpty(request.getReceiveStatus(), "收单状态不能为空");
        if (!Arrays.asList(ReceiveStatus._2.getCode(), ReceiveStatus._3.getCode()).contains(request.getReceiveStatus())) {
            throw new ValidationException("仅支持票已收齐、退回收票");
        }
    }

    @Override
    protected CommonResponse<Boolean> process(UpdateReceiveStatusRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        final List<BaseBill> bills = billService.selectBillDataByBillCodes(user.getTenantId(), request.getBillCodes(), EntityMeta.CompareBaseBill.code());
        checkEmpty(bills, "未查询到单据信息");
        final Map<String, Object> update = new HashMap<>(1);
        update.put(EntityMeta.BaseBill.RECEIVE_STATUS.code(), request.getReceiveStatus());
        //仅支持'收票中'修改为'已收齐待提交'，或者'已收齐待提交'修改为'收票中'
        final long count = bills.stream().filter(bill -> Arrays.asList(ReceiveStatus._2.getCode(), ReceiveStatus._3.getCode()).contains(bill.getReceiveStatus()))
            .map(bill -> billService.updateBillByParam(bill.getId(), update, EntityMeta.CompareBaseBill.code()))
            .count();
        return CommonResponse.ok(String.format("变更成功%s条", count));
    }

}
