package com.xforceplus.elephant.image.controller.compare.billdata.process.commit;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.dispatch.BeanDispatcher;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.BaseBillCommitRequest;
import com.xforceplus.elephant.image.client.model.EntityObj;
import com.xforceplus.elephant.image.core.business.application.compare.bill.event.CompareBillCommitEvent;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.domain.compare.bill.CompareBaseBillService;
import com.xforceplus.elephant.image.core.expand.compare.impl.billimageticket.DefaultCompareBillImageTicketServiceImpl;
import com.xforceplus.elephant.image.core.facade.application.compare.bill.CompareBillFacade;
import com.xforceplus.elephant.image.core.facade.dto.commit.BillCommitFailDto;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BackFlag;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ReceiveStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import io.vavr.Tuple2;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

/**
 * 默认稽核单据提交process类
 *
 * @author liming
 * @date 2021/8/20 13:54
 */
@Dispatch(isDefault = true)
@Service
public class DefaultCompareBillDataCommitProcess extends AbstractProcess<BaseBillCommitRequest, JSONObject> {

    @Autowired
    private CompareBaseBillService baseBillService;
    @Autowired
    private CompareBillFacade billFacade;
    @Autowired
    private MQUtils rabbitmqUtils;
    @Autowired
    private BeanDispatcher beanDispatcher;
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    protected void check(BaseBillCommitRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getEntities(), "entities不能为空");
    }

    @Override
    protected CommonResponse<JSONObject> process(BaseBillCommitRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final List<String> billCodes = request.getEntities().stream().map(EntityObj::getBillCode).collect(Collectors.toList());
        final List<String> commitBillCodes = Lists.newArrayList();
        final StringBuilder message = new StringBuilder();
        final Set<BillCommitFailDto> failDtoList = new LinkedHashSet<>();
        //判断单据状态
        for (String billCode : billCodes) {
            final Tuple2<Boolean, String> commitStatus = beanDispatcher.dispatch(authorizedUser.getTenantId(), DefaultCompareBillImageTicketServiceImpl.class)
                .checkCommit(authorizedUser.getTenantId(), billCode);
            if (commitStatus._1) {
                commitBillCodes.add(billCode);
            } else {
                message.append(commitStatus._2 + "\n");
                failDtoList.add(new BillCommitFailDto(billCode, commitStatus._2));
            }
        }
        if (request.isCheckReceiveStatus() && ValidatorUtil.isNotEmpty(commitBillCodes)) {
            final List<BaseBill> bills = baseBillService.selectBillDataByBillCodes(authorizedUser.getTenantId(), commitBillCodes);
            bills.stream().filter(bill -> !Arrays.asList(ReceiveStatus._3.getCode(), ReceiveStatus._4.getCode(), ReceiveStatus._5.getCode()).contains(bill.getReceiveStatus()))
                .forEach(bill -> {
                    commitBillCodes.remove(bill.getBillCode());
                    message.append(bill.getBillCode()).append("未收齐发票\n");
                    failDtoList.add(new BillCommitFailDto(bill.getBillCode(), String.format("%s未收齐发票", bill.getBillCode())));
                });
        }
        //校验提交
        final int count = defaultCommit(authorizedUser.getTenantId(),
            authorizedUser.getId(), authorizedUser.getUsername(), authorizedUser.getUserCode(), commitBillCodes);
        final JSONObject result = new JSONObject();
        result.put("selectedCount", billCodes.size());
        result.put("successfulCount", count);
        result.put("failedCount", billCodes.size() - count);
        result.put("calculateCount", billCodes.size() - commitBillCodes.size());
        result.put("message", message.toString());
        result.put("failList", failDtoList);
        return CommonResponse.ok("成功", result);
    }

    /**
     * 单据提交至 - 已提交
     *
     * @param tenantId  租户ID
     * @param billCodes billCodes
     * @return int
     * @author rongying
     * @date 2021/4/1 13:58
     */
    private int defaultCommit(Long tenantId, Long userId, String userName, String userCode, List<String> billCodes) {
        if (ValidatorUtil.isEmpty(billCodes)) {
            return 0;
        }
        final List<Long> updateIds = Lists.newArrayList();
        //下发
        final List<Long> sendIds = Lists.newArrayList();
        final List<BaseBill> list = baseBillService.selectBillDataByBillCodes(tenantId, billCodes);
        list.stream().filter(r -> YesNo._0.getCode().equals(r.getIsException())).forEach(dataEntity -> {
            if (null == dataEntity.getExceptionCount() || dataEntity.getExceptionCount() == 0) {
                //已提交
                if (!BillDataStatus._3.getCode().equals(dataEntity.getBillDataStatus())) {
                    final String backFlag = BackFlag._1.getCode().equals(dataEntity.getBackFlag()) ? BackFlag._2.getCode() : null;
                    billFacade.updateBillDataStatus(Arrays.asList(dataEntity.getId()), BillDataStatus._3.getCode(), backFlag);
                }
                sendIds.add(dataEntity.getId());
            }
        });
        //无异常下发
        if (ValidatorUtil.isEmpty(sendIds)) {
            return 0;
        }
        //稽核单据提交事件
        final CompareBillCommitEvent compareBillCommitEvent = new CompareBillCommitEvent(this, tenantId, billCodes, userId, userName, userCode);
        applicationContext.publishEvent(compareBillCommitEvent);
        return sendIds.size();
    }

}
