package com.xforceplus.elephant.image.controller.compare.image.process.personsave;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.dispatch.BeanDispatcher;
import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.system.paas.NotificationUtils;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.ImageDTO;
import com.xforceplus.elephant.image.client.model.SaveImageRequest;
import com.xforceplus.elephant.image.core.business.application.collect.batch.domain.EnableFlowContext;
import com.xforceplus.elephant.image.core.business.application.collect.batch.service.BatchService;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import com.xforceplus.elephant.image.core.business.util.LogUtil;
import com.xforceplus.elephant.image.core.domain.compare.bill.CompareBaseBillService;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.elephant.image.core.domain.config.ConfigDictionaryService;
import com.xforceplus.elephant.image.core.domain.config.ConfigSettingsService;
import com.xforceplus.elephant.image.core.expand.compare.CompareBillImageTicketService;
import com.xforceplus.elephant.image.core.repository.model.BatchTaskEntity;
import com.xforceplus.purchaser.bizratelimiter.model.Application;
import com.xforceplus.purchaser.bizratelimiter.model.BizRequest;
import com.xforceplus.purchaser.bizratelimiter.model.Channel;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageCategory;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.RecStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.xlog.core.model.LogContext;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.groovy.util.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Dispatch(isDefault = true)
@Service
public class DefaultComparePersonSaveProcess extends AbstractProcess<SaveImageRequest, List<Long>> {

    @Autowired
    protected CompareImageService imageService;
    @Autowired
    protected CompareBaseBillService baseBillService;
    @Autowired
    protected NotificationUtils notificationUtils;
    @Autowired
    protected ConfigSettingsService configSettingsService;
    @Autowired
    protected ConfigDictionaryService configDictionaryService;
    @Autowired
    protected CompareBillImageTicketService billImageTicketService;
    @Autowired
    protected MQUtils rabbitmqUtils;
    @Autowired
    protected BeanDispatcher beanDispatcher;
    @Autowired
    protected BatchService batchService;
    @Autowired(required = false)
    private Application application;

    @Override
    protected void check(SaveImageRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getEntities(), "操作对象不能为空");
        if (!YesNo._0.getCode().equals(request.getIsPublic())) {
            throw new RuntimeException("只能上传个人影像");
        }
        for (ImageDTO entity : request.getEntities()) {
            checkEmpty(entity.getImageCategory(), "影像目录不能为空");
            checkEmpty(entity.getImageSource(), "来源不能为空");
            checkEmpty(entity.getFileUrl(), "原始文件路径不能为空");
            checkEmpty(entity.getFileUrlHandle(), "处理文件路径不能为空");
            checkEmpty(entity.getFileType(), "原始文件类型不能为空");
            checkEmpty(entity.getFileTypeHandle(), "处理文件类型不能为空");
        }
    }

    @Override
    protected CommonResponse<List<Long>> process(SaveImageRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        final String batchNo = Long.toString(System.currentTimeMillis());
        final List<Image> images = request.getEntities().stream().map(dto -> {
            final Image entity = Image.fromOQSMap(BeanUtils.convertJSON(dto));
            //上传封面强转附件
            if (ValidatorUtil.isNotEmpty(entity.getBillCode())) {
                entity.setImageType(ImageType._99.getCode());
                entity.setImageCategory(ImageCategory._5.getCode());
            }
            entity.setBatchNo(batchNo);
            entity.setFileOrder("");
            entity.setBillCode(StringUtils.EMPTY);
            entity.setCreateUserCode(user.getUserCode());
            entity.setRequireOcrFlag(YesNo._1.getCode());
            entity.setRecStatus(RecStatus._0.getCode());
            entity.setIsPublic(YesNo._0.getCode());
            return entity;
        }).collect(Collectors.toList());
        final EnableFlowContext context = new EnableFlowContext().setTenantId(user.getTenantId()).setUserId(user.getId());
        final boolean flag = batchService.enable(context);
        LogContext.setLogPoint("enableFlow", flag);
        if (flag) {
            final String channelCode = batchService.getChannelCode(user.getTenantCode());
            final BatchTaskEntity batchTaskEntity = new BatchTaskEntity();
            batchTaskEntity.setTenantId(user.getTenantId());
            batchTaskEntity.setTenantCode(user.getTenantCode());
            batchTaskEntity.setCreateUserId(user.getId());
            batchTaskEntity.setCreateUserName(user.getUsername());
            batchTaskEntity.setCreateTime(new Date());
            batchTaskEntity.setTaskCount(request.getEntities().size());
            batchTaskEntity.setChannelCode(channelCode);
            final Long batchId = batchService.insert(batchTaskEntity);
            images.forEach(image -> image.setBatchNo(String.valueOf(batchId)));
            final Map<String, Object> headers = new HashMap<>();
            headers.put(com.xforceplus.elephant.image.core.business.consts.Constants.TENANT_CODE, user.getTenantCode());
            headers.put("batchNo", batchId);
            headers.put("userInfo", JSONObject.toJSONString(user));
            try {
                if (batchService.sendEnableFlow(context)) {
                    final Channel channel = application.loadChannel(channelCode);
                    final BizRequest bizRequest = BizRequest.builder()
                                                            .bizQuantity(batchTaskEntity.getTaskCount())
                                                            .properties(headers)
                                                            .body(JSONObject.toJSONString(images))
                                                            .attrs(Maps.of("queueName", MQEnum.COMPARE_PERSON_TICKET_SYNC_QUEUE))
                                                            .build();
                    channel.flowInRateLimit(bizRequest);
                } else {
                    rabbitmqUtils.sendByDirectExchange(MQEnum.COMPARE_PERSON_TICKET_SYNC_QUEUE, JSONObject.toJSONString(images), headers);
                }
            } catch (Exception e) {
                LogContext.setLogPoint("enableFlowError", e.getMessage());
                logger.error("使用限流异常", e);
                LogContext.setLogPoint("error", String.format("使用限流异常:%s", e.getMessage()));
                rabbitmqUtils.sendByDirectExchange(MQEnum.COMPARE_PERSON_TICKET_SYNC_QUEUE, JSONObject.toJSONString(images), headers);
            } finally {

                LogUtil.attachSaveCount(CollectionUtils.size(request.getEntities()));
            }
            return CommonResponse.ok("成功");
        }
        final List<Long> imageIds = imageService.saveImages(images);
        LogUtil.attachSaveCount(CollectionUtils.size(request.getEntities()));
        return CommonResponse.ok("成功", imageIds);
    }

}