package com.xforceplus.elephant.image.controller.compare.ticket.process;

import com.google.common.collect.Lists;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.DeleteTicketListRequest;
import com.xforceplus.elephant.image.core.domain.compare.ticket.CompareTicketService;
import com.xforceplus.elephant.image.core.expand.compare.CompareBillImageTicketService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CompareDeletePublicTicketListProcess extends AbstractProcess<DeleteTicketListRequest, Boolean> {

    @Autowired
    private CompareTicketService ticketService;
    @Autowired
    private CompareBillImageTicketService billImageTicketService;

    @Override
    protected void check(DeleteTicketListRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getTicketIds())) {
            throw new ValidationException("单证ID集合【ticketIds】不能为空");
        }
        if (ValidatorUtil.isEmpty(request.getTicketCode())) {
            throw new ValidationException("单证code【ticketCode】不能为空");
        }
    }

    @Override
    protected CommonResponse<Boolean> process(DeleteTicketListRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        boolean result = false;
        final List<Long> imageIds = Lists.newArrayList();
        final List<Ticket> entityList = ticketService.selectTicketList(request.getTicketIds(), request.getTicketCode());
        if (!CollectionUtils.isEmpty(entityList)) {
            imageIds.addAll(entityList.stream().map(r -> r.getImageId()).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty(imageIds)) {
            result = billImageTicketService.deleteImageAndTicketByImageIds(authorizedUser.getTenantId(), imageIds);
        }
        if (result) {
            return CommonResponse.ok("删除成功", true);
        } else {
            return CommonResponse.failed("无记录删除");
        }
    }

}