package com.xforceplus.elephant.image.controller.compare.ticket.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.enums.bill.OperateEnum;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.ReCheckTicketRequest;
import com.xforceplus.elephant.image.core.business.application.calculate.relation.ticket.TicketRelationService;
import com.xforceplus.elephant.image.core.domain.compare.ticket.CompareTicketService;
import com.xforceplus.elephant.image.core.domain.operationlog.OperationLogService;
import com.xforceplus.elephant.image.core.domain.ticket.TicketService;
import com.xforceplus.elephant.image.core.expand.compare.CompareBillImageTicketService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.OperationEntity;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.OperationType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.TicketRelation;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@RequiredArgsConstructor
public class CompareReCheckTicketProcess extends AbstractProcess<ReCheckTicketRequest, Boolean> {

    private final TicketService ticketService;
    private final CompareBillImageTicketService billImageTicketService;
    private final OperationLogService operationLogService;
    private final TicketRelationService ticketRelationService;

    @Override
    protected void check(ReCheckTicketRequest request) throws ValidationException {
        checkEmpty(request.getTicketId(), "单证id不能为空");
        checkEmpty(request.getTicketCode(), "单证code不能为空");
    }

    @Override
    protected CommonResponse<Boolean> process(ReCheckTicketRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        final Map<String, Object> ticket = ticketService.selectByTicketCode(request.getTicketCode(), request.getTicketId());
        if (ValidatorUtil.isEmpty(ticket)) {
            CommonResponse.failed("未查询到该单证!");
        }
        final Long tenantId = MapUtils.getLong(ticket, EntityMeta.Ticket.TENANT_ID.code());
        final boolean onlyCheck;
        if (ticketRelationService.newRelationHandle(tenantId)) {
            final List<TicketRelation> ticketRelationList = ticketRelationService.selectRelations(Arrays.asList(request.getTicketId()));
            onlyCheck = CollectionUtils.isEmpty(ticketRelationList);
        } else {
            onlyCheck = !YesNo._1.getCode().equals(MapUtils.getString(ticket, EntityMeta.Ticket.IS_REPEAT.code()));
        }
        final Long imageId = MapUtils.getLong(ticket, EntityMeta.Ticket.IMAGE_ID.code());
        final String billCode = MapUtils.getString(ticket, EntityMeta.Ticket.BILL_CODE.code());
        if (onlyCheck) {
            final JSONObject ticketJson = new JSONObject();
            ticketJson.putAll(ticket);
            final JSONObject updateJson = billImageTicketService.checkTicketExceAndWarn(tenantId, ticketJson);
            ticketService.updateTicketByParam(request.getTicketId(), request.getTicketCode(), updateJson);
            if (imageId != null) {
                billImageTicketService.updateManyExceWarnData(imageId);
                //修改影像
                billImageTicketService.updateImageExceWarnData(tenantId, imageId);
            }
            if (ValidatorUtil.isNotEmpty(billCode)) {
                billImageTicketService.updateRecogBillInfo(tenantId, billCode);
            }
            operationLogService.insertOperationLog(OperationEntity.TICKET.getCode(), StringHelp.safeToString(request.getTicketId()), OperationType.RE_CHECK_TICKET.getCode(),
                user.getUsername(), "");
            return CommonResponse.ok("重算成功");

        }

        billImageTicketService.checkTicketRepeatAndReuse(tenantId, Arrays.asList(imageId), OperateEnum.HOOK, billCode);
        if (ValidatorUtil.isNotEmpty(billCode)) {
            billImageTicketService.updateRecogBillInfo(tenantId, billCode);
        }
        operationLogService.insertOperationLog(OperationEntity.TICKET.getCode(), StringHelp.safeToString(request.getTicketId()), OperationType.RE_CHECK_TICKET.getCode(),
            user.getUsername(), "");
        return CommonResponse.ok("重算成功");
    }

}
