package com.xforceplus.elephant.image.controller.compare.ticket.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.request.BatchRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.core.business.util.PlainEntityServiceWrapper;
import com.xforceplus.elephant.image.core.domain.compare.ticket.CompareTicketService;
import com.xforceplus.elephant.image.core.expand.compare.CompareBillImageTicketService;
import com.xforceplus.elephant.image.core.util.RequestBuilder;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import java.util.List;
import java.util.Map;
import javax.validation.ValidationException;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 *
 *
 * @author liming
 * @date 2022/11/25 18:23
 */
@Service
public class MatchBillProcess extends AbstractProcess<BatchRequest, Boolean> {

    @Autowired
    private CompareTicketService ticketService;
    @Autowired
    private CompareBillImageTicketService compareBillImageTicketService;
    @Autowired
    private PlainEntityServiceWrapper plainEntityService;

    @Override
    protected void check(BatchRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getIds())) {
            throw new ValidationException("单证ID集合【ids】不能为空");
        }
    }

    @Override
    protected CommonResponse<Boolean> process(BatchRequest request) throws RuntimeException {
        // 获取登录用户上下文
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final ConditionQueryRequest ticketRequest = new RequestBuilder()
                .field(EntityMeta.Ticket.TENANT_ID.code(), ConditionOp.eq, authorizedUser.getTenantId())
                .field(EntityMeta.Ticket.ID.code(), ConditionOp.in, request.getIds())
                .build();
        final List<Map<String, Object>> ticketList = plainEntityService.findByCondition(EntityMeta.CompareTicket.code(), ticketRequest).getRows();
        ticketList.forEach(ticketMap -> {
            final Long ticketId = MapUtils.getLong(ticketMap, EntityMeta.Ticket.ID.code());
            final String ticketCode = MapUtils.getString(ticketMap, EntityMeta.Ticket.TICKET_CODE.code());
            final String billCode = MapUtils.getString(ticketMap, EntityMeta.Ticket.BILL_CODE.code());
            compareBillImageTicketService.matchBill(authorizedUser.getTenantId(), ticketCode, ticketMap);
            final JSONObject updateJson = compareBillImageTicketService.checkTicketExceAndWarn(authorizedUser.getTenantId(), new JSONObject(ticketMap));
            ticketService.updateTicketByParam(ticketId, ticketCode, updateJson);
            if (ValidatorUtil.isNotEmpty(billCode)) {
                compareBillImageTicketService.updateRecogBillInfo(authorizedUser.getTenantId(), billCode);
            }
        });
        return CommonResponse.ok("成功", true);
    }
}
