package com.xforceplus.elephant.image.controller.logapi.process;

import com.xforceplus.elephant.basecommon.baseconst.ConfigConstants;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.GetMethodCodeRequest;
import com.xforceplus.elephant.image.core.domain.config.ConfigDictionaryService;
import com.xforceplus.elephant.image.core.domain.config.bean.ConfigDictionaryItem;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetMethodCodeProcess extends AbstractProcess<GetMethodCodeRequest, String> {

    @Autowired
    private ConfigDictionaryService configDictionaryService;

    @Override
    protected CommonResponse<String> process(GetMethodCodeRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();

        final List<ConfigDictionaryItem> dictionaryItemList = configDictionaryService.selectItems(authorizedUser.getTenantId(), ConfigConstants.LOG_CONFIG);
        if (ValidatorUtil.isEmpty(dictionaryItemList)) {
            CommonResponse.failed("获取不到配置项");
        }
        final Map<String, String> dictionaryMap = dictionaryItemList.stream().collect(Collectors.toMap(ConfigDictionaryItem::getItemCode, ConfigDictionaryItem::getItemValue));
        String result = "";

        if (Integer.valueOf(0).equals(request.getType())) {
            result = dictionaryMap.get("logApi");

        } else if (Integer.valueOf(1).equals(request.getType())) {
            result = dictionaryMap.get("logMq");

        } else if (Integer.valueOf(2).equals(request.getType())) {
            result = dictionaryMap.get("pubSubLog");

        }
        return CommonResponse.ok("", result);
    }

}
