package com.xforceplus.elephant.image.controller.task;

import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.api.TaskApi;
import com.xforceplus.elephant.image.core.business.application.collect.task.enums.TaskTypeEnum;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.business.util.LogUtil;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author liuhongbin
 * @description 接收任务回调
 * @date 2021/3/17 15:45
 */
@Slf4j
@RequiredArgsConstructor
@ApiV1Image
public class TaskController implements TaskApi {

    @Resource
    private HttpServletRequest httpServletRequest;
    private final MQUtils rabbitmqUtils;

    @Override
    public CommonResponse callback(String taskType, @RequestBody String message) {
        log.info("接收任务类型：{}，消息体：{}", taskType, message);
        final TaskTypeEnum taskTypeEnum = TaskTypeEnum.fromType(taskType);
        if (taskTypeEnum == null) {
            return CommonResponse.failed("不存在的任务类型");
        }
        log.info("分发消息到{}", taskTypeEnum.getName());
        final Map<String, Object> properties = httpServletRequest.getParameterMap().entrySet().stream()
            .collect(Collectors.toMap(entry -> entry.getKey(), entry -> StringUtils.join(entry.getValue(), ",")));
        rabbitmqUtils.sendByDirectExchange(taskTypeEnum.getMqName(), message, properties);

        LogUtil.attachTenantInfo(MapUtils.getString(properties,com.xforceplus.elephant.image.core.business.consts.Constants.TENANT_CODE));
        LogUtil.attachTaskType(taskTypeEnum);

        return CommonResponse.ok("接收成功");
    }

}
