package com.xforceplus.elephant.image.controller.ticket.process;

import static com.xforceplus.elephant.image.core.business.consts.Constants.TENANT_CODE;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.enums.EntityConstant;
import com.xforceplus.elephant.basecommon.enums.common.WebsocketNoticeTypeEnum;
import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.SendVerifyRequest;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import com.xforceplus.elephant.image.core.domain.ticket.TicketService;
import com.xforceplus.elephant.image.core.expand.BillImageTicketService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.CheckStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket;
import java.util.HashMap;
import java.util.Map;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SendVerifyProcess extends AbstractProcess<SendVerifyRequest, Boolean> {

    @Autowired
    private TicketService ticketService;
    @Autowired
    private BillImageTicketService billImageTicketService;
    @Autowired
    private MQUtils rabbitmqUtils;

    @Override
    protected void check(SendVerifyRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getTicketId())) {
            throw new ValidationException("单证ID【ticketId】不能为空");
        }
    }

    @Override
    protected CommonResponse<Boolean> process(SendVerifyRequest request) throws RuntimeException {
        final Ticket entity = ticketService.selectBaseTicketById(request.getTicketId());
        if (null == entity) {
            return CommonResponse.failed("没有找到可操作的数据.");
        }
        if (CheckStatus._1.getCode().equals(entity.getCheckStatus())) {
            return CommonResponse.failed("发票已处于验真中，请稍后重试.");
        }
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆.");
        }
        final Map<String, Object> entityMap = ticketService.selectByParentTicketID(EntityConstant.TICKET, entity.getTicketCode(), request.getTicketId());
        if (null == entityMap) {
            return CommonResponse.failed("没有找到可操作的数据.");
        }
        final Map<String, Object> updateMap = billImageTicketService
            .checkedVerify(authorizedUser.getTenantId(), entity.getTicketCode(), entityMap, authorizedUser.getId(), authorizedUser.getUsername());
        if (updateMap.size() > 0) {
            if (updateMap.get("check_status") == null) {
                return CommonResponse.failed(updateMap.get("check_remark").toString());
            }
            final Long ticketId = Long.valueOf(entityMap.get("id").toString());
            final JSONObject updateJson = billImageTicketService.checkTicketExceAndWarn(authorizedUser.getTenantId(), new JSONObject(entityMap));
            if (null != updateJson && updateJson.size() > 0) {
                updateJson.entrySet().forEach(r -> updateMap.put(r.getKey(), r.getValue()));
            }
            final Integer count = ticketService.updateTicketByParam(ticketId, entity.getTicketCode(), updateMap);
            if (count > 0) {
                billImageTicketService.updateImageExceWarnData(authorizedUser.getTenantId(), entity.getImageId());
            }
        }
        return CommonResponse.ok("发送验真成功.");
    }

    /**
     * 发送通知
     *
     * @param authorizedUser 用户
     * @param billCode       业务单号
     */
    private void sendWebScoket(IAuthorizedUser authorizedUser, String billCode) {
        final JSONObject mqMessage = new JSONObject();
        mqMessage.put("noticeType", WebsocketNoticeTypeEnum.CHECK_EXCEPTION_AND_WARNING.getCode());
        mqMessage.put("tenantId", authorizedUser.getTenantId());
        mqMessage.put("source", "发送验真完成");
        mqMessage.put("createUserId", authorizedUser.getId());
        mqMessage.put("billCode", billCode);
        final Map<String, Object> headers = new HashMap<>();
        headers.put(TENANT_CODE, authorizedUser.getTenantCode());
        rabbitmqUtils.sendByTopicExchange(MQEnum.WEBSOCKET_NOTICE_QUEUE, mqMessage, headers);
    }

}