package com.xforceplus.elephant.image.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.rabbitmq.client.Channel;
import com.xforceplus.domain.user.UserDto;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.rabbitmq.BaseRabbitmqListener;
import com.xforceplus.elephant.image.core.business.application.collect.batch.service.BatchService;
import com.xforceplus.elephant.image.core.business.application.collect.task.domain.FileTransformTypeConfig;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import com.xforceplus.elephant.image.core.business.util.LogUtil;
import com.xforceplus.elephant.image.core.domain.imagefile.ImageFileService;
import com.xforceplus.elephant.image.core.expand.BillImageTicketService;
import com.xforceplus.elephant.image.core.facade.application.collect.upload.UploadFacade;
import com.xforceplus.elephant.image.core.repository.model.BatchTaskEntity;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.ImageFile;
import java.util.Date;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

@Slf4j
@Component
@RequiredArgsConstructor
public class UploadImageSyncListener extends BaseRabbitmqListener {

    private final ContextService contextService;
    private final BatchService batchService;
    private final ImageFileService imageFileService;
    private final UploadFacade uploadFacade;
    private final BillImageTicketService billImageTicketService;

    @RabbitListener(bindings = @QueueBinding(value = @Queue(value = MQEnum.UPLOAD_IMAGE_SYNC_QUEUE), exchange = @Exchange(value = MQEnum.DIRECT_EXCHANGE), key = MQEnum.UPLOAD_IMAGE_SYNC_QUEUE))
    @Override
    public void onMessage(Message message, Channel channel) throws Exception {
        final Long batchNo = MapUtils.getLong(message.getMessageProperties().getHeaders(), "batchNo");

        final UserDto userDto = JSON.parseObject(StringHelp.safeToString(message.getMessageProperties().getHeaders().get("userInfo")), UserDto.class);
        try {
            contextService.set(ContextKeys.StringKeys.TENANTID_KEY, String.valueOf(userDto.getTenantId()));
            contextService.set(ContextKeys.StringKeys.TENANTCODE_KEY, userDto.getTenantCode());
            contextService.set(ContextKeys.LongKeys.ID, userDto.getId());
            contextService.set(ContextKeys.StringKeys.USER_DISPLAYNAME, userDto.getUsername());
            if (batchNo != null) {
                LogUtil.attachFlowBatchNo(batchNo.toString());
                final BatchTaskEntity update = new BatchTaskEntity();
                update.setId(batchNo);
                update.setUpdateTime(new Date());
                update.setBatchStatus(1);
                batchService.update(update);
            }
            final FileTransformTypeConfig fileTransformTypeConfig = imageFileService.getFileTransformTypeConfig(userDto.getTenantId());
            final JSONArray requestDtos = JSON.parseArray(new String(message.getBody()));
            boolean flag = false;
            for (int i = 0; i < requestDtos.size(); i++) {
                final JSONObject dto = requestDtos.getJSONObject(i);
                final Image image = dto.getObject("image", Image.class);
                final ImageFile imageFile = dto.getObject("imageFile", ImageFile.class);
                if (YesNo._0.getCode().equals(imageFile.getRequireOcrFlag())) {
                    flag = true;
                }
                uploadFacade.executeUpload(null, imageFile.getFileSuffix(), image, imageFile, fileTransformTypeConfig);
            }
            if (flag) {
                billImageTicketService.resetLevel(batchNo.toString(), userDto.getId());
            }
        } catch (Exception e) {
            log.error("保存文件上传异常", e);
        } finally {
            contextService.clear();
        }
    }

}
