package com.xforceplus.elephant.image.controller.batchnumberrule.process;

import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.UpdateBatchNumberRuleRequest;
import com.xforceplus.elephant.image.core.repository.model.BatchNumberRuleEntity;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import javax.validation.ValidationException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class UpdateBatchNumberRuleProcess extends AbstractBatchNumberRuleProcess<UpdateBatchNumberRuleRequest, Boolean> {

    @Override
    protected void check(UpdateBatchNumberRuleRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getRuleId(), "主键不能为空!");
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        //校验规则名称不能重复
        if (ValidatorUtil.isNotEmpty(request.getRuleName())) {
            final BatchNumberRuleEntity batchNumberRuleEntity = batchNumberRuleFacade.selectByName(request.getRuleName(), authorizedUser.getTenantId());
            if (batchNumberRuleEntity != null && !request.getRuleId().equals(batchNumberRuleEntity.getId())) {
                throw new ValidationException("规则名称已存在");
            }
        }
        if (ValidatorUtil.isNotEmpty(request.getRuleCode())) {
            final BatchNumberRuleEntity codeBatchNumberRuleEntity = batchNumberRuleFacade.selectByCode(request.getRuleCode(), authorizedUser.getTenantId());
            if (codeBatchNumberRuleEntity != null && !request.getRuleId().equals(codeBatchNumberRuleEntity.getId())) {
                throw new ValidationException("规则编号重复");
            }
        }
        if (ValidatorUtil.isNotEmpty(request.getRuleDefine())) {
            checkRuleDefine(request.getRuleDefine());
        }
    }

    @Override
    protected CommonResponse<Boolean> process(UpdateBatchNumberRuleRequest request) throws RuntimeException {
        final boolean result = batchNumberRuleFacade.updateById(request.getRuleId(), BeanUtils.convertJSON(request));
        return CommonResponse.ok("成功", result);
    }

}
