package com.xforceplus.elephant.image.controller.compare.image.process;

import com.xforceplus.elephant.basecommon.enums.image.ImageReturnStatusEnum;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.CancelReturnImageRequest;
import com.xforceplus.elephant.image.core.business.consts.Constants;
import com.xforceplus.elephant.image.core.domain.compare.bill.CompareBaseBillService;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BackStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BackType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CompareCancelReturnImageProcess extends AbstractProcess<CancelReturnImageRequest, Boolean> {

    @Autowired
    private CompareImageService imageService;
    @Autowired
    private CompareBaseBillService baseBillService;

    @Override
    protected void check(CancelReturnImageRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getImageIds())) {
            throw new ValidationException("影像ID集合【imageIds】不能为空");
        }
    }

    @Override
    protected CommonResponse<Boolean> process(CancelReturnImageRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        final List<Image> imageList = imageService.selectImages(authorizedUser.getTenantId(), request.getImageIds())
            .stream().filter(r -> BackStatus._1.getCode().equals(r.getReturnStatus()))
            .collect(Collectors.toList());
        if (CollectionUtils.isEmpty(imageList)) {
            return CommonResponse.failed("没有找到可取消退回打标记的影像数据.");
        }
        if (!StringHelp.safeIsEmpty(request.getBillCode())) {
            final BaseBill billEntity = baseBillService.selectBaseBillByCode(authorizedUser.getTenantId(), request.getBillCode());
            if (null != billEntity && BillDataStatus._4.getCode().equals(billEntity.getBillDataStatus())) {
                return CommonResponse.failed("单据已退回，不可取消退回打标记.");
            }
        }
        final List<Long> imageIds = imageList.stream().map(r -> r.getId()).collect(Collectors.toList());
        final boolean result = imageService.updateImageBackStatus(authorizedUser.getTenantId(), imageIds,
            BackType._0.getCode(), Constants.ZERO, "",
            authorizedUser.getId(), authorizedUser.getUsername());
        String message = "取消退回打标记成功";
        if (imageIds.size() != request.getImageIds().size()) {
            message = String.format("%d条记录成功取消退回打标记%d条", request.getImageIds().size(), imageIds.size());
        }
        return CommonResponse.ok(message, result);
    }

}
