package com.xforceplus.elephant.image.controller.compare.image.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.process.AbstractKeyProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.RotateImageRequest;
import com.xforceplus.elephant.image.core.business.infrastructure.port.FileService;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.validation.ValidationException;
import net.coobird.thumbnailator.Thumbnails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompareRotateImageProcess extends AbstractKeyProcess<Long, RotateImageRequest, Boolean> {

    @Autowired
    private CompareImageService imageService;
    @Autowired
    private FileService fileService;

    @Override
    protected void check(Long tenantId, RotateImageRequest request) throws ValidationException {
        super.check(tenantId, request);
    }

    @Override
    protected CommonResponse<Boolean> process(Long imageId, RotateImageRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        final Image entity = imageService.selectOne(user.getTenantId(), imageId);
        if (null == entity) {
            return CommonResponse.failed("未查询到该影像!");
        }
        //360°无需旋转角度处理影像
        if (ValidatorUtil.isNotEmpty(request.getRotate()) && Integer.valueOf(360).equals(request.getRotate())) {
            return CommonResponse.ok("成功", true);
        }
        if (ValidatorUtil.isEmpty(entity.getFileUrlHandle())) {
            return CommonResponse.failed("该影像地址为空!");
        }
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            InputStream is = null;
            if (entity.getFileUrlHandle().startsWith("http")) {
                is = HttpUtils.doGetInputStream(entity.getFileUrlHandle());
            } else {
                is = fileService.getFileInputStream(user.getTenantId(), user.getId(), entity.getFileUrlHandle());
            }

            Thumbnails.of(is)
                .rotate(request.getRotate())
                .scale(1)
                .toOutputStream(baos);
        } catch (Exception e) {
            throw new ElephantException("图片处理异常");
        }
        final String fileName = new StringBuilder("image_").append(imageId)
            .append("_").append(System.currentTimeMillis())
            .append(".").append(entity.getFileTypeHandle())
            .toString();
        final Long fileKey = fileService.uploadFile(user.getTenantId(), user.getId(), fileName, new ByteArrayInputStream(baos.toByteArray()));
        final JSONObject update = new JSONObject();
        if (ValidatorUtil.isEmpty(entity.getFileUrlOrigin())) {
            update.put("file_url_origin", entity.getFileUrlHandle());
        }
        final String url = fileService.getFileUrl(user.getTenantId(), user.getId(), fileKey);
        update.put("file_url_handle", url);
        final Integer integer = imageService.updateByParam(imageId, update);
        if (integer > 0) {
            return CommonResponse.ok("成功", true);
        } else {
            return CommonResponse.failed("更新失败");
        }
    }

}
