package com.xforceplus.elephant.image.controller.image.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.request.BatchRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.elephant.image.core.domain.ticket.TicketService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.RecStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.util.List;
import java.util.stream.Collectors;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Slf4j
@Service
@RequiredArgsConstructor
public class ReRecImageProcess extends AbstractProcess<BatchRequest, Boolean> {

    private final ImageService imageService;
    private final TicketService ticketService;

    @Override
    protected CommonResponse<Boolean> process(BatchRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        final List<Image> images = imageService.selectImages(user.getTenantId(), request.getIds());
        checkEmpty(images, "影像不存在");
        final List<Long> imageIds = images.stream()
            .filter(image -> YesNo._1.getCode().equals(image.getRequireOcrFlag()))
            .map(Image::getId)
            .collect(Collectors.toList());
        final List<Ticket> tickets = ticketService.selectBaseTicketByImageIds(user.getTenantId(), imageIds);
        checkEmpty(tickets, "勾选影像为无需识别");
        final long count = tickets.stream()
            .filter(ticket -> EntityMeta.TicketAttachment.code().equals(ticket.getTicketCode()))
            .map(ticket -> {
                final boolean result = ticketService.deleteBaseTicketByID(ticket.getId()) > 0;
                if (!result) {
                    return false;
                }
                final JSONObject update = new JSONObject();
                update.put(EntityMeta.Image.REC_STATUS.code(), RecStatus._0.getCode());
                return imageService.updateByParam(ticket.getImageId(), update);
            }).count();
        final String message = String.format("勾选%s条，成功重新发起识别%s条，剩余%s条为无需识别或非附件", request.getIds().size(), count, request.getIds().size() - count);
        if (count > 0) {
            return CommonResponse.ok(message, true);
        }
        return CommonResponse.failed("重新识别失败");
    }

}
