package com.xforceplus.elephant.image.controller.label.process;

import com.xforceplus.elephant.basecommon.baseconst.Constants;
import com.xforceplus.elephant.basecommon.enums.label.LabelStatusEnum;
import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.GetLabelListRequest;
import com.xforceplus.elephant.image.client.model.LabelDTO;
import com.xforceplus.elephant.image.core.domain.label.LabelService;
import com.xforceplus.elephant.image.core.facade.application.collect.label.SystemLabelFacade;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.SystemLabel;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

@RequiredArgsConstructor
@Service
public class GetLabelListProcess extends AbstractProcess<GetLabelListRequest, List> {

    private final LabelService labelService;

    private final SystemLabelFacade systemLabelFacade;

    @Override
    protected CommonResponse<List> process(GetLabelListRequest request) throws RuntimeException {
        // 获取登录用户上下文
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        //个人标签
        if (ValidatorUtil.isNotEmpty(request.getType())) {
            return selectLabel(request, authorizedUser.getTenantId(), authorizedUser.getId());
        }
        //系统标签
        final List<SystemLabel> systemLabelList = systemLabelFacade.selectList(authorizedUser.getTenantId(), request.getName());
        return CommonResponse.ok("成功", systemLabelList);
    }

    /**
     * 查询个人标签
     *
     * @param request  查询参数
     * @param tenantId 租户ID
     * @param userId   userId
     * @return 结果
     * @author rongying
     * @date 2021/3/23 11:47
     */
    private CommonResponse<List> selectLabel(GetLabelListRequest request, Long tenantId, Long userId) {
        if (!Constants.NUMBER_ONE.toString().equals(request.getType().toString())) {
            throw new ValidationException("type传参不合法【默认系统标签，1-个人标签】");
        }
        final List<LabelDTO> resultList = labelService.selectLabelData(tenantId, userId, LabelStatusEnum.ENABLE.getCode(), request.getName())
            .stream().map(entity -> {
                final LabelDTO dto = new LabelDTO();
                BeanUtils.copyProperties(entity, dto);
                return dto;
            }).collect(Collectors.toList());
        return CommonResponse.ok("成功", resultList);
    }

}