package com.xforceplus.elephant.image.controller.label.process;

import com.xforceplus.elephant.basecommon.enums.label.LabelStatusEnum;
import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.help.DateHelp;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.SaveLabelRequest;
import com.xforceplus.elephant.image.core.domain.label.LabelService;
import com.xforceplus.elephant.image.core.repository.model.LabelEntity;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import java.util.List;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SaveLabelProcess extends AbstractProcess<SaveLabelRequest, List<Long>> {

    @Autowired
    private LabelService labelService;

    @Override
    protected void check(SaveLabelRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getLabelName(), "标签名称【labelName】不能为空");
        checkEmpty(request.getEnable(), "是否启用【enable】不能为空");
    }

    @Override
    protected CommonResponse<List<Long>> process(SaveLabelRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆.");
        }
        final List<LabelEntity> tempList = labelService.checkLabelName(authorizedUser.getTenantId(), authorizedUser.getId(), request.getLabelName());
        int count = 0;
        if (CollectionUtils.isEmpty(tempList)) {
            final LabelEntity labelEntity = tempList.get(0);
            if (!LabelStatusEnum.DELETE.getCode().equals(labelEntity.getEnable())) {
                return CommonResponse.failed("标签名称不允许重复");
            }
            labelEntity.setLabelName(request.getLabelName());
            labelEntity.setLabelRemark(request.getLabelRemark());
            labelEntity.setEnable(request.getEnable());
            labelEntity.setTenantId(authorizedUser.getTenantId());
            labelEntity.setUpdateTime(DateHelp.getNowDate());
            labelEntity.setUpdateUserId(authorizedUser.getId());
            labelEntity.setUpdateUserName(authorizedUser.getUsername());
            count = labelService.updateLabelData(labelEntity);
        } else {
            final LabelEntity labelEntity = new LabelEntity();
            BeanUtils.copyProperties(request, labelEntity);
            labelEntity.setTenantId(authorizedUser.getTenantId());
            labelEntity.setCreateTime(DateHelp.getNowDate());
            labelEntity.setCreateUserId(authorizedUser.getId());
            labelEntity.setCreateUserName(authorizedUser.getUsername());
            count = labelService.insertLabelData(labelEntity).intValue();
        }
        if (count > 0) {
            return CommonResponse.ok("保存成功");
        }
        return CommonResponse.failed("无保存记录");
    }

}