package com.xforceplus.elephant.image.controller.multipurpose;

import com.google.api.client.util.Lists;
import com.xforceplus.domain.user.UserDto;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.ShareImageRequest;
import com.xforceplus.elephant.image.client.model.UsedAmountRequest;
import com.xforceplus.elephant.image.client.model.UsedAmountResponse;
import com.xforceplus.elephant.image.core.business.application.collect.ticket.service.TicketService;
import com.xforceplus.elephant.image.core.business.application.collect.ticket.service.impl.MultipurposeApplicationService;
import com.xforceplus.elephant.image.core.business.infrastructure.port.UserService;
import com.xforceplus.elephant.image.core.domain.config.ConfigSettingsService;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.elephant.image.core.domain.multipurpose.MultipurposeService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta.Ticket;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2024/11/4 11:21
 */
@RequiredArgsConstructor
@Component
public class MultipurposeProcess {

    private final UserService userService;
    private final ImageService imageService;
    private final MultipurposeApplicationService multipurposeApplicationService;
    private final MultipurposeService multipurposeService;
    private final ConfigSettingsService configSettingsService;
    private final TicketService ticketService;

    public CommonResponse<String> shareImage(ShareImageRequest shareImageRequest) {

        final IAuthorizedUser currentUser = UserInfoHolder.get();
        final String isMultipurposeTicket = configSettingsService.select(currentUser.getTenantId(),
            EntityMeta.ConfigSettings.IS_MULTIPURPOSE_TICKET.code(), String.class, YesNo._0.getCode());
        if (YesNo._0.getCode().equals(isMultipurposeTicket)) {
            return CommonResponse.failed("没有开启一票多用");
        }

        final List<UserDto> userDtoList = Lists.newArrayList();
        for (long userId : shareImageRequest.getShareUserIds()) {
            final UserDto userDto = userService.getUser(userId, currentUser.getTenantId());
            if (userDto == null) {
                return CommonResponse.failed("被分享人没有注册");
            }
            userDtoList.add(userDto);
        }
        final Optional<Map<String, Object>> ticketOptional = ticketService.getTicketById(shareImageRequest.getTicketId());

        if (!ticketOptional.isPresent()) {
            return CommonResponse.failed("分享的单证不存在");
        }

        final Map<String, Object> ticketMap = ticketOptional.get();

        final Image image = imageService.selectOne(MapUtils.getLong(ticketMap, EntityMeta.Ticket.IMAGE_ID.code()));
        if (image == null) {
            return CommonResponse.failed("分享的影像不存在");
        }

        final String commitStatus = MapUtils.getString(ticketMap, Ticket.COMMIT_STATUS.code(), YesNo._0.code());
        if (!StringUtils.equals(commitStatus, YesNo._1.code())) {
            return CommonResponse.failed("单证没有提交，不能分享");
        }

        final BigDecimal balanceAmount = new BigDecimal(MapUtils.getString(ticketMap, EntityMeta.Ticket.BALANCE_AMOUNT.code(), "0"));
        if (BigDecimal.ZERO.compareTo(balanceAmount) >= 0) {
            return CommonResponse.failed("单证没有余额，不能分享");
        }

        final String invoiceNo = MapUtils.getString(ticketMap, Ticket.INVOICE_NO.code());
        final String invoiceCode = MapUtils.getString(ticketMap, Ticket.INVOICE_CODE.code());

        for (UserDto user : userDtoList) {
            final Map<String, Object> paramMap = new HashMap<>();
            paramMap.put(EntityMeta.Ticket.SCAN_USER_ID.code(), user.getId());
            final List<com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket> multiList = ticketService.selectByInvoiceNoCodeParam(user.getTenantId(), invoiceNo, invoiceCode, paramMap);
            if (ValidatorUtil.isNotEmpty(multiList) && multiList.size() > 1) {
                return CommonResponse.failed("分享的影像，用户：" + user.getUsername() + " 已经存在");
            }
        }

        multipurposeApplicationService.copyTicket(image, ticketMap, userDtoList);

        return CommonResponse.ok("分享成功");
    }

    public CommonResponse editUsedAmount(UsedAmountRequest request) {
        final IAuthorizedUser currentUser = UserInfoHolder.get();
        if (!multipurposeService.isMultipurposeEnabled(currentUser.getTenantId())) {
            return CommonResponse.failed("没有开启一票多用");
        }

        final com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket ticket = ticketService.selectTicketById(request.getTicketId());
        if (null == ticket) {
            return CommonResponse.failed("没有找到原单证数据.");
        }

        final Either<String, Tuple2<BigDecimal, BigDecimal>> result = multipurposeService.editUsedAmount(ticket, new BigDecimal(request.getUsedAmount()));

        if (result.isLeft()) {
            return CommonResponse.failed(result.getLeft());
        } else {
            final UsedAmountResponse usedAmountResponse = new UsedAmountResponse();
            usedAmountResponse.setUsedAmount(result.get()._1);
            usedAmountResponse.setBalanceAmount(result.get()._2);
            return CommonResponse.ok("success", usedAmountResponse);
        }
    }

}
