package com.xforceplus.elephant.image.controller.ticket.process;

import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.GetHistoryLabelsRequest;
import com.xforceplus.elephant.image.core.business.application.collect.label.service.SystemLabelService;
import com.xforceplus.elephant.image.core.util.ValidateUtils;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.SystemLabelsHistory;
import java.util.List;
import java.util.Optional;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Dispatch(isDefault = true)
@Service
public class GetHistoryLabelsProcess extends AbstractProcess<GetHistoryLabelsRequest, List<SystemLabelsHistory>> {

    @Autowired
    private SystemLabelService systemLabelService;

    @Override
    protected void check(GetHistoryLabelsRequest request) throws ValidationException {
        // 基础校验
        ValidateUtils.validate(request);
    }

    @Override
    protected CommonResponse<List<SystemLabelsHistory>> process(GetHistoryLabelsRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        return CommonResponse.ok("成功", systemLabelService.listSystemLabelsHistoryOrderCreateTime(authorizedUser.getId(),
            Optional.ofNullable(request.getLimit()).orElse(100)));
    }

}