package com.xforceplus.elephant.image.controller.ticket.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.SelectTicketAttachmentRequest;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.elephant.image.core.domain.ticket.TicketService;
import com.xforceplus.elephant.image.core.expand.BillImageTicketService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SelectTicketAttachmentProcess extends AbstractProcess<SelectTicketAttachmentRequest, JSONObject> {

    @Autowired
    private ImageService imageService;
    @Autowired
    private TicketService ticketService;
    @Autowired
    private BillImageTicketService billImageTicketService;

    @Override
    protected void check(SelectTicketAttachmentRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getImageId(), "imageId不能为空!");
    }

    @Override
    protected CommonResponse<JSONObject> process(SelectTicketAttachmentRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        final JSONObject jsonObject = billImageTicketService.selectTicketAttachmentAndSalesList(authorizedUser.getTenantId(), request.getImageId());
        return CommonResponse.ok("", jsonObject);
    }

}
