package com.xforceplus.elephant.image.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.rabbitmq.client.Channel;
import com.xforceplus.domain.user.UserDto;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.rabbitmq.BaseRabbitmqListener;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.core.business.application.collect.batch.service.BatchService;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.elephant.image.core.domain.ticket.TicketService;
import com.xforceplus.elephant.image.core.expand.BillImageTicketService;
import com.xforceplus.elephant.image.core.facade.application.collect.upload.UploadFacade;
import com.xforceplus.elephant.image.core.repository.model.BatchTaskEntity;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

@Slf4j
@Component
@RequiredArgsConstructor
public class UploadAttachImageSyncListener extends BaseRabbitmqListener {

    private final ContextService contextService;
    private final BatchService batchService;
    private final UploadFacade uploadFacade;
    private final ImageService imageService;
    private final TicketService ticketService;
    private final BillImageTicketService billImageTicketService;

    @RabbitListener(bindings = @QueueBinding(value = @Queue(value = MQEnum.UPLOAD_ATTACH_IMAGE_SYNC_QUEUE), exchange = @Exchange(value = MQEnum.DIRECT_EXCHANGE),
        key = MQEnum.UPLOAD_ATTACH_IMAGE_SYNC_QUEUE))
    @Override
    public void onMessage(Message message, Channel channel) throws Exception {
        final Long batchNo = MapUtils.getLong(message.getMessageProperties().getHeaders(), "batchNo");
        final UserDto userDto = JSON.parseObject(StringHelp.safeToString(message.getMessageProperties().getHeaders().get("userInfo")), UserDto.class);
        try {
            contextService.set(ContextKeys.StringKeys.TENANTID_KEY, String.valueOf(userDto.getTenantId()));
            contextService.set(ContextKeys.StringKeys.TENANTCODE_KEY, userDto.getTenantCode());
            contextService.set(ContextKeys.LongKeys.ID, userDto.getId());
            contextService.set(ContextKeys.StringKeys.USER_DISPLAYNAME, userDto.getUsername());
            if (batchNo != null) {
                final BatchTaskEntity update = new BatchTaskEntity();
                update.setId(batchNo);
                update.setUpdateTime(new Date());
                update.setBatchStatus(1);
                batchService.update(update);
            }
            final JSONObject body = JSON.parseObject(new String(message.getBody()));
            final JSONObject ticketJson = body.getJSONObject("ticketJson");
            final JSONArray requestDtos = body.getJSONArray("requestDtos");
            for (int i = 0; i < requestDtos.size(); i++) {
                final JSONObject dto = requestDtos.getJSONObject(i);
                final JSONObject json = dto.getJSONObject("image");
                final Map<String, Object> ticket = dto.getJSONObject("ticket");
                final List<Long> imageIds = imageService.saveForMap(Arrays.asList(json));
                final Image image = Image.fromOQSMap(json);
                image.setId(imageIds.get(0));
                uploadFacade.saveTicketAttach(image, ticket, EntityMeta.TicketAttachment.code());
            }
            //重算发票异常
            final JSONObject updateJson = billImageTicketService.checkTicketExceAndWarn(userDto.getTenantId(), ticketJson);
            if (ValidatorUtil.isNotEmpty(updateJson)) {
                final Integer count = ticketService.updateTicketByParam(ticketJson.getLong(EntityMeta.Ticket.ID.code()), ticketJson.getString(EntityMeta.Ticket.TICKET_CODE.code()), updateJson);
                if (count > 0) {
                    final long imageId = ticketJson.getLong(EntityMeta.Ticket.IMAGE_ID.code());
                    billImageTicketService.updateManyExceWarnData(imageId);
                    //修改影像
                    billImageTicketService.updateImageExceWarnData(userDto.getTenantId(), imageId);
                }
            }
            final String billCode = ticketJson.getString(EntityMeta.Ticket.BILL_CODE.code());
            if (ValidatorUtil.isNotEmpty(billCode)) {
                billImageTicketService.updateRecogBillInfo(userDto.getTenantId(), billCode);
            }
            final BatchTaskEntity update = new BatchTaskEntity();
            update.setId(batchNo);
            update.setFinishTime(new Date());
            update.setBatchStatus(2);
            batchService.update(update);
        } catch (Exception e) {
            log.error("保存附件上传异常", e);
        } finally {
            contextService.clear();
        }
    }

}
