package com.xforceplus.elephant.image.mapper;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.image.client.model.InsertBillImageRequest;
import com.xforceplus.elephant.image.client.model.InsertImageDTO;
import com.xforceplus.elephant.image.client.model.UploadImageDTO;
import com.xforceplus.elephant.image.client.model.UploadRequest;
import com.xforceplus.elephant.image.core.facade.dto.upload.UploadImageDto;
import com.xforceplus.elephant.image.core.facade.dto.upload.UploadImageRequestDto;
import com.xforceplus.elephant.image.core.facade.dto.upload.UploadImageRequestDto.UploadImageRequestDtoBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-10-11T16:58:32+0800",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 1.8.0_111 (Oracle Corporation)"
)
@Component
public class UploadMapperImpl implements UploadMapper {

    @Override
    public UploadImageRequestDto map(InsertBillImageRequest request) {
        if ( request == null ) {
            return null;
        }

        UploadImageRequestDtoBuilder uploadImageRequestDto = UploadImageRequestDto.builder();

        uploadImageRequestDto.uploadImageDtoList( insertImageDTOListToUploadImageDtoList( request.getInsertImageDTOList() ) );
        uploadImageRequestDto.uploadAttachmentImageDtoList( insertImageDTOListToUploadImageDtoList( request.getInsertAttachmentImageDTOList() ) );
        uploadImageRequestDto.billCode( request.getBillCode() );
        uploadImageRequestDto.parentImageId( request.getParentImageId() );
        uploadImageRequestDto.imageSource( request.getImageSource() );
        uploadImageRequestDto.isPublic( request.getIsPublic() );
        JSONObject jSONObject = request.getExt();
        if ( jSONObject != null ) {
            uploadImageRequestDto.ext( new JSONObject( jSONObject ) );
        }

        return uploadImageRequestDto.build();
    }

    @Override
    public UploadImageRequestDto map(UploadRequest request) {
        if ( request == null ) {
            return null;
        }

        UploadImageRequestDtoBuilder uploadImageRequestDto = UploadImageRequestDto.builder();

        uploadImageRequestDto.uploadImageDtoList( uploadImageDTOListToUploadImageDtoList( request.getUploadImageDTOList() ) );
        uploadImageRequestDto.uploadAttachmentImageDtoList( uploadImageDTOListToUploadImageDtoList( request.getUploadAttachmentImageDTOList() ) );
        uploadImageRequestDto.billCode( request.getBillCode() );
        uploadImageRequestDto.parentImageId( request.getParentImageId() );
        uploadImageRequestDto.systemOrig( request.getSystemOrig() );
        uploadImageRequestDto.serialNumber( request.getSerialNumber() );
        uploadImageRequestDto.billEntityCode( request.getBillEntityCode() );
        uploadImageRequestDto.isPublic( request.getIsPublic() );
        JSONObject jSONObject = request.getExt();
        if ( jSONObject != null ) {
            uploadImageRequestDto.ext( new JSONObject( jSONObject ) );
        }
        uploadImageRequestDto.requireOcrFlag( request.getRequireOcrFlag() );
        uploadImageRequestDto.orgId( request.getOrgId() );
        uploadImageRequestDto.orgCode( request.getOrgCode() );
        uploadImageRequestDto.orgName( request.getOrgName() );

        return uploadImageRequestDto.build();
    }

    @Override
    public UploadImageDto map(UploadImageDTO request) {
        if ( request == null ) {
            return null;
        }

        UploadImageDto uploadImageDto = new UploadImageDto();

        uploadImageDto.setFileStream( request.getFileStream() );
        uploadImageDto.setFileType( request.getFileType() );
        uploadImageDto.setFileName( request.getFileName() );
        uploadImageDto.setFileOrder( request.getFileOrder() );

        return uploadImageDto;
    }

    protected UploadImageDto insertImageDTOToUploadImageDto(InsertImageDTO insertImageDTO) {
        if ( insertImageDTO == null ) {
            return null;
        }

        UploadImageDto uploadImageDto = new UploadImageDto();

        uploadImageDto.setFileStream( insertImageDTO.getFileStream() );
        uploadImageDto.setFileType( insertImageDTO.getFileType() );
        uploadImageDto.setFileName( insertImageDTO.getFileName() );
        uploadImageDto.setFileOrder( insertImageDTO.getFileOrder() );

        return uploadImageDto;
    }

    protected List<UploadImageDto> insertImageDTOListToUploadImageDtoList(List<InsertImageDTO> list) {
        if ( list == null ) {
            return null;
        }

        List<UploadImageDto> list1 = new ArrayList<UploadImageDto>( list.size() );
        for ( InsertImageDTO insertImageDTO : list ) {
            list1.add( insertImageDTOToUploadImageDto( insertImageDTO ) );
        }

        return list1;
    }

    protected List<UploadImageDto> uploadImageDTOListToUploadImageDtoList(List<UploadImageDTO> list) {
        if ( list == null ) {
            return null;
        }

        List<UploadImageDto> list1 = new ArrayList<UploadImageDto>( list.size() );
        for ( UploadImageDTO uploadImageDTO : list ) {
            list1.add( map( uploadImageDTO ) );
        }

        return list1;
    }
}
