package com.xforceplus.elephant.image.controller.check;

import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.controller.check.domain.CheckUserConfigDTO;
import com.xforceplus.elephant.image.controller.check.process.CheckDataInitProcess;
import com.xforceplus.elephant.image.core.business.application.calculate.check.config.CheckConfigService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.CheckCategory;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.CheckDisplayText;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.CheckUserConfig;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

@ApiV1Image
@RequiredArgsConstructor
public class CheckController {

    private final CheckConfigService checkConfigService;
    private final CheckDataInitProcess checkDataInitProcess;

    @ApiOperation("检测项列表")
    @GetMapping(value = "/check/{category}", produces = {"application/json"})
    public CommonResponse<List<CheckUserConfigDTO>> list(@PathVariable("category") String category) {
        final IAuthorizedUser user = UserInfoHolder.get();
        final Map<String, List<CheckUserConfig>> userConfigGroupMap = checkConfigService.loadUserConfigsByGroup(user.getTenantCode(), CheckCategory.fromCode(category));
        final List<CheckUserConfigDTO> dtoList = userConfigGroupMap.entrySet().stream().map(entry -> new CheckUserConfigDTO(entry.getKey(), entry.getValue())).collect(Collectors.toList());
        return CommonResponse.ok("成功", dtoList);
    }

    @ApiOperation("检测项文案列表")
    @GetMapping(value = "/check/{id}/texts", produces = {"application/json"})
    public CommonResponse<List<CheckDisplayText>> texts(@PathVariable("id") Long id) {
        final CheckUserConfig checkUserConfig = checkConfigService.loadUserConfig(id);
        if (checkUserConfig == null) {
            return CommonResponse.failed("配置不存在");
        }
        checkUserConfig.setTenant(UserInfoHolder.get().getTenantCode());
        return CommonResponse.ok("成功", checkConfigService.loadDisplayTexts(checkUserConfig));
    }

    @ApiOperation("检测项更新")
    @PutMapping(value = "/check/{id}", produces = {"application/json"})
    public CommonResponse<Boolean> saveUserConfig(@PathVariable("id") Long id, @RequestBody CheckUserConfig userConfig) {
        final CheckUserConfig checkUserConfig = checkConfigService.loadUserConfig(id);
        if (checkUserConfig == null) {
            return CommonResponse.failed("配置不存在");
        }
        final IAuthorizedUser user = UserInfoHolder.get();
        userConfig.setTenant(user.getTenantCode());
        userConfig.setCategory(checkUserConfig.getCategory());
        userConfig.setCode(checkUserConfig.getCode());
        userConfig.setName(checkUserConfig.getName());
        userConfig.setDesc(checkUserConfig.getDesc());
        userConfig.setGroup(checkUserConfig.getGroup());
        final Integer count = checkConfigService.save(userConfig);
        if (count <= 0) {
            return CommonResponse.failed("更新失败");
        }
        return CommonResponse.ok("成功");
    }

    @ApiOperation("检测项文案更新")
    @PutMapping(value = "/check/text/{id}", produces = {"application/json"})
    public CommonResponse<Boolean> saveDisplayText(@PathVariable("id") Long id, @RequestBody CheckDisplayText displayText) {
        final CheckDisplayText checkDisplayText = checkConfigService.loadDisplayText(id);
        if (checkDisplayText == null) {
            return CommonResponse.failed("文案配置不存在");
        }
        final IAuthorizedUser user = UserInfoHolder.get();
        displayText.setTenant(user.getTenantCode());
        displayText.setCategory(checkDisplayText.getCategory());
        displayText.setCode(checkDisplayText.getCode());
        displayText.setKey(checkDisplayText.getKey());
        displayText.setDesc(checkDisplayText.getDesc());
        final Integer count = checkConfigService.save(displayText);
        if (count <= 0) {
            return CommonResponse.failed("更新失败");
        }
        return CommonResponse.ok("成功");
    }

    @ApiOperation("初始化数据")
    @GetMapping("/check/init")
    public CommonResponse<Boolean> init() {
        return checkDataInitProcess.execute(new BaseRequest());
    }

}
