package com.xforceplus.elephant.image.controller.common.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.core.domain.config.ConfigSettingsService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetSettingsProcess extends AbstractProcess<BaseRequest, JSONObject> {

    @Autowired
    private ConfigSettingsService configSettingsService;

    @Override
    protected CommonResponse<JSONObject> process(BaseRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        final JSONObject settings = configSettingsService.select(authorizedUser.getTenantId());
        return CommonResponse.ok("成功", settings);
    }

}
