package com.xforceplus.elephant.image.controller.common.process;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.baseconst.ConfigConstants;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.system.paas.OrgUtils;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.core.domain.common.UserDepartMentBean;
import com.xforceplus.elephant.image.core.domain.config.ConfigDictionaryService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetUserDepartmentProcess extends AbstractProcess<BaseRequest, JSONArray> {

    @Autowired
    private ConfigDictionaryService configDictionaryService;
    @Autowired
    private OrgUtils orgUtils;

    @Override
    protected CommonResponse<JSONArray> process(BaseRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        final JSONArray jsonArray = new JSONArray();
        final Map<String, String> params = new HashMap<>(2);
        params.put("tenantId", user.getTenantId().toString());
        params.put("userId", user.getId().toString());
        params.put("row", "100");
        final JSONArray orgInfos = orgUtils.getOrgs(user.getTenantId(), params);
        if (ValidatorUtil.isEmpty(orgInfos)) {
            return CommonResponse.ok("用户中心查询为空", jsonArray);
        }
        final String items = configDictionaryService.select(user.getTenantId(),
            ConfigConstants.CONFIG_DICT_CODE_USER_DEPARTMENT);
        if (ValidatorUtil.isEmpty(items)) {
            return CommonResponse.ok("配置查询为空", jsonArray);
        }
        List<UserDepartMentBean> userDepartMentBeans = JSONObject.parseArray(items, UserDepartMentBean.class);
        if (ValidatorUtil.isEmpty(userDepartMentBeans)) {
            return CommonResponse.ok("配置查询为空!", jsonArray);
        }
        userDepartMentBeans = userDepartMentBeans.stream().filter(userDepartMentBean -> userDepartMentBean.isDefault()).collect(Collectors.toList());
        final List<JSONObject> jsonObjectList = userDepartMentBeans.get(0).getDepartments();
        final Map<Long, JSONObject> userDepartmentMap = jsonObjectList.stream()
            .collect(Collectors.toMap(item -> item.getLong("orgId"), Function.identity(), (oldValue, newValue) -> newValue));
        for (int i = 0; i < orgInfos.size(); i++) {
            final JSONObject org = orgInfos.getJSONObject(i);
            if (ValidatorUtil.isEmpty(org)) {
                continue;
            }
            final Long orgId = org.getLong("orgId");
            if (!userDepartmentMap.containsKey(orgId)) {
                continue;
            }
            final JSONObject jsonObject = userDepartmentMap.get(orgId);
            if (ValidatorUtil.isNotEmpty(jsonObject) && ValidatorUtil.isNotEmpty(jsonObject.getInteger("enable")) && YesNo._1.getCode().equals(jsonObject.getString("enable"))) {
                jsonArray.add(jsonObject);
            }

        }

        return CommonResponse.ok("成功", jsonArray);
    }

}
