package com.xforceplus.elephant.image.controller.common.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.ConfigSettingRequest;
import com.xforceplus.elephant.image.core.business.application.config.common.service.ConfigService;
import com.xforceplus.elephant.image.core.business.consts.ConfigTypeEnum;
import com.xforceplus.elephant.image.core.business.consts.Constants;
import com.xforceplus.elephant.image.core.business.enums.DictEnum;
import com.xforceplus.elephant.image.core.domain.config.ConfigSettingsService;
import com.xforceplus.elephant.image.core.facade.base.BaseFacade;
import com.xforceplus.elephant.image.core.util.RequestBuilder;
import com.xforceplus.general.utils.EnumUtil;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.ConfigDictionary;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.ConfigSettings;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@RequiredArgsConstructor
@Service
public class SaveConfigSettingProcess extends AbstractProcess<ConfigSettingRequest, String> {

    private final ConfigSettingsService configSettingsService;
    private final BaseFacade baseFacade;
    private final ConfigService configService;

    @Override
    protected void check(final ConfigSettingRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getData(), "保存的设置不能为空");
    }

    @Override
    protected CommonResponse<String> process(final ConfigSettingRequest request) throws RuntimeException {
        if (MapUtils.isEmpty(request.getData())) {
            return CommonResponse.ok("成功");
        }

        final IAuthorizedUser user = UserInfoHolder.get();
        final ConfigTypeEnum typeEnum = EnumUtil.fromValue(ConfigTypeEnum.class, request.getCode());

        if (ConfigTypeEnum.BASE.equals(typeEnum)) {
            configSettingsService.save(user.getTenantId(), ConfigSettings.fromOQSMap(request.getData()));
        }
        if (ConfigTypeEnum.WATERMARK.equals(typeEnum)) {
            final ConditionQueryRequest configRequest = new RequestBuilder()
                .field(EntityMeta.ConfigDictionary.TENANT.code(), ConditionOp.eq, user.getTenantId())
                .field(EntityMeta.ConfigDictionary.DICT_CODE.code(), ConditionOp.eq, DictEnum.WATERMARK_CONFIG.getCode())
                .build();
            final List<Map<String, Object>> dictionaryMaps = baseFacade.findByCondition(EntityMeta.ConfigDictionary.code(), configRequest).getRows();
            final ConfigDictionary dictionary = dictionaryMaps.isEmpty() ? new ConfigDictionary() : ConfigDictionary.fromOQSMap(dictionaryMaps.get(0));
            if (dictionary.getId() != null) {
                final Map<String, Object> update = new HashMap<>();
                update.put(EntityMeta.ConfigDictionary.DICT_VALUE.code(), String.valueOf(request.getData()));
                update.put(EntityMeta.ConfigDictionary.UPDATE_USER_ID.code(), user.getId());
                update.put(EntityMeta.ConfigDictionary.UPDATE_USER_NAME.code(), user.getUserName());
                baseFacade.updateById(EntityMeta.ConfigDictionary.code(), dictionary.getId(), update);
            } else {
                dictionary.setDictCode(DictEnum.WATERMARK_CONFIG.getCode());
                dictionary.setDictDesc(String.format("【%s】水印配置", user.getTenantName()));
                dictionary.setTenant(user.getTenantId());
                dictionary.setIsDefault(YesNo._0.getCode());
                dictionary.setEnable(YesNo._1.getCode());
                dictionary.setTenantId(user.getTenantId());
                dictionary.setTenantCode(user.getTenantCode());
                dictionary.setCreateTime(LocalDateTime.now());
                dictionary.setCreateUserId(user.getId());
                dictionary.setCreateUserName(user.getUserName());
                dictionary.setDictValue(String.valueOf(request.getData()));
                baseFacade.create(EntityMeta.ConfigDictionary.code(), dictionary.toOQSMap());
            }
        }
        if (ConfigTypeEnum.REC_TICKET_CODE.equals(typeEnum)) {
            configSettingsService.save(user.getTenantId(), ConfigSettings.fromOQSMap(request.getData()));
        }
        if (ConfigTypeEnum.COVER_TICKET.equals(typeEnum)) {
            final ConfigDictionary ticketCoverDictionary = Optional.ofNullable(configService.selectDictionaryWithoutEnable(user.getTenantId(), DictEnum.TICKET_COVER_CONFIG.getCode()))
                .orElse(new ConfigDictionary());
            if (YesNo._1.getCode().equals(ticketCoverDictionary.getIsDefault())) {
                ticketCoverDictionary.setId(null);
                ticketCoverDictionary.setDictDesc(String.format("【%s】%s", user.getTenantName(), ticketCoverDictionary.getDictDesc()));
                ticketCoverDictionary.setIsDefault(YesNo._0.getCode());
                ticketCoverDictionary.setTenantId(user.getTenantId());
                ticketCoverDictionary.setTenantCode(user.getTenantCode());
                ticketCoverDictionary.setTenant(user.getTenantId());
                ticketCoverDictionary.setEnable(request.getData().getString(EntityMeta.ConfigDictionary.ENABLE.code()));
                ticketCoverDictionary.setCreateTime(LocalDateTime.now());
                ticketCoverDictionary.setCreateUserId(user.getId());
                ticketCoverDictionary.setCreateUserName(user.getUserName());
                baseFacade.create(EntityMeta.ConfigDictionary.code(), ticketCoverDictionary.toOQSMap());
            } else {
                baseFacade.updateById(EntityMeta.ConfigDictionary.code(), ticketCoverDictionary.getId(), request.getData());
            }
        }
        if (ConfigTypeEnum.DEL_SUB_UNHOOK_TICKET.equals(typeEnum)) {
            saveDelSubUnHookDictionary(request, user);
        }
        return CommonResponse.ok("成功");
    }

    private void saveDelSubUnHookDictionary(final ConfigSettingRequest request, final IAuthorizedUser user) {
        final JSONObject ruleConfig = getRuleConfig(request, user.getTenantId());
        final String message = ruleConfig.getString("message");
        final String expression = ruleConfig.getString("expression");
        checkEmpty(expression, "我的单证删除配置业务规则不能为空");

        boolean isChange = false;
        JSONArray configs = new JSONArray();
        ConfigDictionary configDictionary = configService.selectDictionary(user.getTenantId(), DictEnum.TICKET_DELETE_CONFIG.getCode());
        if (null != configDictionary) {
            configs = JSON.parseArray(configDictionary.getDictValue());
            for (Object item : configs) {
                final JSONObject config = (JSONObject) item;
                final String notDeleteExpression = config.getString("notDeleteExpression");
                if (!StringUtils.equals(notDeleteExpression, expression)) {
                    logger.info("saveDelSubUnHookDictionary id[{}] source[{}] target[{}]", configDictionary.getId(), notDeleteExpression, expression);
                    isChange = true;
                    config.put("notDeleteExpression", expression);
                    if (StringUtils.isNotBlank(message)) {
                        config.put("message", message);
                    }
                }
            }
        } else {
            isChange = true;
        }

        if (isChange) {
            configDictionary = Optional.ofNullable(configDictionary).orElse(new ConfigDictionary());
            if (YesNo._1.getCode().equals(configDictionary.getIsDefault())) {
                final JSONObject config = new JSONObject();
                config.put("notDeleteExpression", expression);
                config.put("message", message);
                configs.add(config);

                configDictionary.setId(null);
                configDictionary.setDictValue(JSON.toJSONString(configs));
                configDictionary.setDictDesc(String.format("【%s】%s", user.getTenantName(), configDictionary.getDictDesc()));
                configDictionary.setIsDefault(YesNo._0.getCode());
                configDictionary.setTenantId(user.getTenantId());
                configDictionary.setTenantCode(user.getTenantCode());
                configDictionary.setTenant(user.getTenantId());
                // 该配置项的启用禁用 不是真正意义上的禁用 故而默认为启用即可
                configDictionary.setEnable(Constants.One);
                configDictionary.setCreateTime(LocalDateTime.now());
                configDictionary.setCreateUserId(user.getId());
                configDictionary.setCreateUserName(user.getUserName());
                baseFacade.create(EntityMeta.ConfigDictionary.code(), configDictionary.toOQSMap());
            } else {
                configDictionary.setDictValue(JSON.toJSONString(configs));
                baseFacade.updateById(EntityMeta.ConfigDictionary.code(), configDictionary.getId(), configDictionary.toOQSMap());
            }
        }
    }

    private JSONObject getRuleConfig(final ConfigSettingRequest request, final Long tenantId) {
        JSONObject config = new JSONObject();
        final String reqKey = "enable";
        final String reqValue = request.getData().getString(reqKey);
        // 查询 删除业务规则配置
        final JSONArray businessRuleConfigs = JSON.parseArray(configService.selectDict(tenantId, DictEnum.TICKET_DELETE_CONFIG_RULE.getCode()));
        for (Object item : businessRuleConfigs) {
            final JSONObject configItem = (JSONObject) item;
            if (reqKey.equals(configItem.getString("key")) && StringUtils.equals(reqValue, configItem.getString("value"))) {
                config = configItem;
                break;
            }
        }
        return config;
    }

}
