package com.xforceplus.elephant.image.controller.compare.billdata.process;

import com.alibaba.fastjson.JSONObject;
import com.google.api.client.util.Lists;
import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.BackCompareBillRequest;
import com.xforceplus.elephant.image.core.business.application.compare.bill.service.CompareBillService;
import com.xforceplus.elephant.image.core.business.application.config.common.domain.CompareScanConfig;
import com.xforceplus.elephant.image.core.business.application.config.common.service.ConfigService;
import com.xforceplus.elephant.image.core.business.enums.DictEnum;
import com.xforceplus.elephant.image.core.domain.compare.bill.CompareBaseBillService;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.AuditStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.RecStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ReceiveStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.ultraman.metadata.domain.record.EmptyValue;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.validation.ValidationException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Dispatch(isDefault = true)
@Service
public class BackCompareBillDataProcess extends AbstractProcess<BackCompareBillRequest, Boolean> {

    @Autowired
    private CompareBaseBillService compareBaseBillService;
    @Autowired
    private CompareImageService imageService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private CompareBillService compareBillService;

    @Override
    protected void check(BackCompareBillRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getBillCodes(), "billCodes不能为空");
    }

    @Override
    protected CommonResponse<Boolean> process(BackCompareBillRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();// 获取登录用户上下文
        if (null == user) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final List<BaseBill> billEntityList = compareBaseBillService.selectBillDataByBillCodes(user.getTenantId(), request.getBillCodes());
        if (ValidatorUtil.isEmpty(billEntityList)) {
            return CommonResponse.failed("无记录回退");
        }
        final CompareScanConfig compareScanConfig = Optional.ofNullable(configService.selectDictObj(user.getTenantId(), DictEnum.COMPARE_SCAN_CONFIG.getCode(), CompareScanConfig.class))
            .orElse(new CompareScanConfig());
        //判断单据下影像是否识别完
        final List<Long> updateBillIds = Lists.newArrayList();
        final List<String> backBillCodes = Lists.newArrayList();
        final List<String> cantBackBillCodes = Lists.newArrayList();
        final List<String> issueBillCodes = Lists.newArrayList();
        billEntityList.stream().forEach(baseBill -> {
            if (baseBill.getAuditStatus() != null && (AuditStatus._1.getCode().equals(String.valueOf(baseBill.getAuditStatus())) || AuditStatus._2.getCode()
                .equals(String.valueOf(baseBill.getAuditStatus())))) {
                issueBillCodes.add(baseBill.getBillCode());
            }
            final List<Image> images = imageService.selectImageByBillCode(user.getTenantId(), baseBill.getBillCode());
            final long count = images.stream()
                .filter(entity -> !Arrays.asList(RecStatus._2.getCode(), RecStatus._3.getCode()).contains(String.valueOf(entity.getRecStatus())))
                .count();
            if (count > 0) {
                cantBackBillCodes.add(baseBill.getBillCode());
                return;
            }
            updateBillIds.add(baseBill.getId());
            backBillCodes.add(baseBill.getBillCode());
        });
        String message = "回退成功";
        if (ValidatorUtil.isEmpty(updateBillIds)) {
            message = String.format("单据%s未完成识别，不可回退", StringHelp.join(cantBackBillCodes, "、"));
            return CommonResponse.failed(message);
        }
        //final boolean result = billImageTicketService.deleteBillData(authorizedUser.getTenantId(), updateBillCodes, false);

        //如果是业务单来源的数据，则清理提单数据
        if (compareScanConfig.isBizOrder()) {
            compareBillService.deleteMainBillAndPushCompareTicket(user.getTenantId(), backBillCodes);
        }
        //更新稽核单据状态
        this.updateCompareBillStatus(updateBillIds);

        if (ValidatorUtil.isNotEmpty(cantBackBillCodes)) {
            message = String.format("单据%回退成功；单据%s未完成识别，不可回退",
                StringHelp.join(updateBillIds, "、"),
                StringHelp.join(cantBackBillCodes, "、"));
        }
        //同步更新并下发主数据单据信息
        if (ValidatorUtil.isNotEmpty(issueBillCodes) && compareScanConfig.isBillCreate()) {
            compareBillService.resetAuditAndPushMainBill(user.getTenantId(), user.getTenantCode(), issueBillCodes, user.getId(), user.getUserName());
        }
        return CommonResponse.ok(message, true);

    }

    /**
     * 更新稽核单据状态为待提交
     *
     * @param billIds billIds
     */
    private void updateCompareBillStatus(List<Long> billIds) {
        final JSONObject jsonObject = new JSONObject();
        jsonObject.put("bill_data_status", BillDataStatus._0.getCode());
        jsonObject.put("audit_status", AuditStatus._0.getCode());
        jsonObject.put(EntityMeta.BaseBill.AUDIT_TIME.code(), EmptyValue.emptyValue);
        jsonObject.put(EntityMeta.BaseBill.AUDIT_USER_ID.code(), 0);
        jsonObject.put(EntityMeta.BaseBill.AUDIT_USER_NAME.code(), StringUtils.EMPTY);
        jsonObject.put("audit_remark", "");
        jsonObject.put("compare_status", EmptyValue.emptyValue);
        jsonObject.put("bill_data_time", System.currentTimeMillis());
        jsonObject.put(EntityMeta.BaseBill.RECEIVE_STATUS.code(), ReceiveStatus._5.getCode());

        billIds.forEach(billId -> compareBaseBillService.updateByBillIdSelective(billId, jsonObject));
    }

}