package com.xforceplus.elephant.image.controller.compare.image.process;

import com.xforceplus.elephant.basecommon.process.AbstractKeyProcess;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.elephant.image.core.expand.compare.CompareBillImageTicketService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import java.util.Arrays;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 删除封面影像
 *
 * @author rongying
 * @date 2021/5/20 15:38
 */
@Service
public class CompareDeleteCoverImageProcess extends AbstractKeyProcess<Long, BaseRequest, Boolean> {

    @Autowired
    private CompareImageService imageService;
    @Autowired
    private CompareBillImageTicketService billImageTicketService;

    @Override
    protected CommonResponse<Boolean> process(Long imageId, BaseRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final Image image = imageService.selectOne(imageId);
        if (ValidatorUtil.isEmpty(image)) {
            return CommonResponse.failed("没有找到该影像数据");
        }
        final boolean result = imageService.deleteImages(Arrays.asList(imageId));
        if (result) {
            if (ValidatorUtil.isNotEmpty(image.getBillCode())) {
                billImageTicketService.updateRecogBillInfo(authorizedUser.getTenantId(), image.getBillCode());
            }
            return CommonResponse.ok("成功", result);
        }
        return CommonResponse.failed("删除失败");
    }

}
