package com.xforceplus.elephant.image.controller.compare.image.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.process.AbstractKeyProcess;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.BaseBillDTO;
import com.xforceplus.elephant.image.client.model.ImageDTO;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompareGetImageDetailProcess extends AbstractKeyProcess<Long, BaseRequest, ImageDTO> {

    @Autowired
    private CompareImageService imageService;

    @Override
    protected CommonResponse<ImageDTO> process(Long imageId, BaseRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        final Image entity = imageService.selectOne(authorizedUser.getTenantId(), imageId);
        final ImageDTO dto = new JSONObject(entity.toOQSMap()).toJavaObject(ImageDTO.class);
        return CommonResponse.ok("成功", dto);
    }

}