package com.xforceplus.elephant.image.controller.compare.image.process;

import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.BillSelectAllRequest;
import com.xforceplus.elephant.image.core.domain.image.bean.ImageSearchBean;
import com.xforceplus.elephant.image.core.facade.application.collect.image.ImageFacade;
import com.xforceplus.elephant.image.mapper.ImageSearchMapper;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.util.List;
import java.util.stream.Collectors;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Slf4j
@RequiredArgsConstructor
@Component
public class CompareImageProcessService {

    private final ImageFacade imageFacade;
    private final ImageSearchMapper mapper;

    /**
     * 准备要操作的数据 格式化全选反选数据到ids 需要注意此处是要考虑全选操作是带着筛选条件的
     *
     * @param request 请求
     * @return void
     * @author liming
     * @date 2021/7/30 11:18
     */
    public void prepareOperateData(BillSelectAllRequest request) {
        //全选
        final IAuthorizedUser user = UserInfoHolder.get();
        if (request.isAllSelected()) {
            //条件筛选
            final ImageSearchBean searchBean = mapper.map(request);
            searchBean.setTenantId(user.getTenantId());
            final List<Image> imageList = imageFacade.selectBillImagesByCustomTicketParams(searchBean, EntityMeta.CompareImage.code()).getRows();
            final List<Long> ids = imageList.stream()
                .filter(image -> !ImageType._1.getCode().equals(image.getImageType()))
                .map(image -> image.getId())
                .collect(Collectors.toList());
            if (ValidatorUtil.isNotEmpty(request.getExcluded())) {
                final List<Long> excludedList = request.getExcluded().stream().map(s -> Long.parseLong(s)).collect(Collectors.toList());
                ids.removeAll(excludedList);
            }
            request.setIds(ids);
        }
        //非全选
        if (!request.isAllSelected()) {
            final List<Long> ids = request.getIncluded().stream().map(s -> Long.parseLong(s)).collect(Collectors.toList());
            request.setIds(ids);
        }
    }
}
