package com.xforceplus.elephant.image.controller.compare.ticket.process;

import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.GetBaseTicketListRequest;
import com.xforceplus.elephant.image.core.facade.application.compare.ticket.CompareTicketFacade;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import java.util.List;
import java.util.Map;
import javax.validation.ValidationException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 获取基础单证列表
 *
 * @author rongying
 * @date 2021/5/14 13:56
 */
@Slf4j
@Service
public class CompareGetBaseTicketListProcess extends AbstractProcess<GetBaseTicketListRequest, List<Map<String, Object>>> {

    @Autowired
    private CompareTicketFacade ticketFacade;

    @Override
    protected void check(GetBaseTicketListRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getBillCode())) {
            throw new ValidationException("billCode不能为空");
        }
    }

    @Override
    protected CommonResponse<List<Map<String, Object>>> process(GetBaseTicketListRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final List<Map<String, Object>> ticketList = ticketFacade.getTicketListByBillCode(authorizedUser.getTenantId(), request.getBillCode());
        return CommonResponse.ok("成功", ticketList);
    }

}