package com.xforceplus.elephant.image.controller.logapi.process;

import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.process.AbstractKeyProcess;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.LogApiDTO;
import com.xforceplus.elephant.image.core.repository.dao.LogApiDao;
import com.xforceplus.elephant.image.core.repository.model.LogApiEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.xforceplus.elephant.image.core.domain.image.ImageService;

@Service
public class GetLogApiDetailProcess extends AbstractKeyProcess<Long, BaseRequest, LogApiDTO> {

    @Autowired
    private LogApiDao logApiDao;

    @Override
    protected CommonResponse<LogApiDTO> process(Long logId, BaseRequest request) throws RuntimeException {

        final LogApiEntity entity = logApiDao.selectByPrimaryKey(logId);
        final LogApiDTO dto = new LogApiDTO();
        BeanUtils.copyProperties(entity, dto);
        return CommonResponse.ok("成功", dto);
    }

}