package com.xforceplus.elephant.image.controller.logisticspostcode;

import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.process.response.ListResult;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.api.LogisticsPostcodeApi;
import com.xforceplus.elephant.image.client.model.GetLogisticsPostcodeListRequest;
import com.xforceplus.elephant.image.client.model.LogisticsPostcodeDTO;
import com.xforceplus.elephant.image.client.model.SaveLogisticsPostcodeRequest;
import com.xforceplus.elephant.image.client.model.UpdateLogisticsPostcodeRequest;
import com.xforceplus.elephant.image.controller.BaseController;
import com.xforceplus.elephant.image.controller.logisticspostcode.process.DeleteLogisticsPostcodeProcess;
import com.xforceplus.elephant.image.controller.logisticspostcode.process.GetLogisticsPostcodeDetailProcess;
import com.xforceplus.elephant.image.controller.logisticspostcode.process.GetLogisticsPostcodeListProcess;
import com.xforceplus.elephant.image.controller.logisticspostcode.process.SaveLogisticsPostcodeProcess;
import com.xforceplus.elephant.image.controller.logisticspostcode.process.UpdateLogisticsPostcodeProcess;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 版权：    上海云砺信息科技有限公司 创建者: 创建时间: 功能描述: 修改历史:
 */
@ApiV1Image
public class LogisticsPostcodeController extends BaseController implements LogisticsPostcodeApi {

    @Autowired
    private DeleteLogisticsPostcodeProcess deleteLogisticsPostcodeProcess;
    @Autowired
    private GetLogisticsPostcodeDetailProcess getLogisticsPostcodeDetailProcess;
    @Autowired
    private GetLogisticsPostcodeListProcess getLogisticsPostcodeListProcess;
    @Autowired
    private SaveLogisticsPostcodeProcess saveLogisticsPostcodeProcess;
    @Autowired
    private UpdateLogisticsPostcodeProcess updateLogisticsPostcodeProcess;

    @Override
    public CommonResponse<Boolean> deleteLogisticsPostcode(@PathVariable("logisticsPostcodeId") Long logisticsPostcodeId, @RequestBody BaseRequest request) {
        return deleteLogisticsPostcodeProcess.execute(logisticsPostcodeId, request);
    }

    @Override
    public CommonResponse<LogisticsPostcodeDTO> getLogisticsPostcodeDetail(@PathVariable("logisticsPostcodeId") Long logisticsPostcodeId, BaseRequest request) {
        return getLogisticsPostcodeDetailProcess.execute(logisticsPostcodeId, request);
    }

    @Override
    public CommonResponse<ListResult<LogisticsPostcodeDTO>> getLogisticsPostcodeList(GetLogisticsPostcodeListRequest request) {
        return getLogisticsPostcodeListProcess.execute(request);
    }

    @Override
    public CommonResponse<List<Long>> saveLogisticsPostcode(@RequestBody SaveLogisticsPostcodeRequest request) {
        return saveLogisticsPostcodeProcess.execute(request);
    }

    @Override
    public CommonResponse<Boolean> updateLogisticsPostcode(@RequestBody UpdateLogisticsPostcodeRequest request) {
        return updateLogisticsPostcodeProcess.execute(request);
    }

}