package com.xforceplus.elephant.image.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.rabbitmq.client.Channel;
import com.xforceplus.domain.user.UserDto;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.rabbitmq.BaseRabbitmqListener;
import com.xforceplus.elephant.image.common.ScanCommonService;
import com.xforceplus.elephant.image.core.business.application.collect.batch.service.BatchService;
import com.xforceplus.elephant.image.core.business.consts.Constants;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import com.xforceplus.elephant.image.core.business.util.LogUtil;
import com.xforceplus.elephant.image.core.repository.model.BatchTaskEntity;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import java.util.Date;
import java.util.List;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

@Slf4j
@Component
@RequiredArgsConstructor
public class InsertBillScanSyncListener extends BaseRabbitmqListener {

    private final ContextService contextService;
    private final BatchService batchService;
    private final ScanCommonService scanCommonService;

    @RabbitListener(bindings = @QueueBinding(value = @Queue(value = MQEnum.INSERT_BILL_SCAN_SYNC_QUEUE), exchange = @Exchange(value = MQEnum.DIRECT_EXCHANGE),
        key = MQEnum.INSERT_BILL_SCAN_SYNC_QUEUE))
    @Override
    public void onMessage(Message message, Channel channel) throws Exception {
        final Long batchNo = MapUtils.getLong(message.getMessageProperties().getHeaders(), "batchNo");
        final UserDto userDto = JSON.parseObject(StringHelp.safeToString(message.getMessageProperties().getHeaders().get("userInfo")), UserDto.class);
        LogUtil.attachBacklogMills(System.currentTimeMillis() - MapUtils.getLong(message.getMessageProperties().getHeaders(), Constants.START_TIME));
        try {
            contextService.set(ContextKeys.StringKeys.TENANTID_KEY, String.valueOf(userDto.getTenantId()));
            contextService.set(ContextKeys.StringKeys.TENANTCODE_KEY, userDto.getTenantCode());
            contextService.set(ContextKeys.LongKeys.ID, userDto.getId());
            contextService.set(ContextKeys.StringKeys.USER_DISPLAYNAME, userDto.getUsername());
            if (batchNo != null) {
                final BatchTaskEntity update = new BatchTaskEntity();
                update.setId(batchNo);
                update.setUpdateTime(new Date());
                update.setBatchStatus(1);
                batchService.update(update);
            }
            final JSONObject body = JSON.parseObject(new String(message.getBody()));
            final BaseBill bill = body.getObject("bill", BaseBill.class);
            final Image parentImage = body.getObject("parentImage", Image.class);
            final List<JSONObject> images = body.getObject("images", new TypeReference<List<JSONObject>>() {
            });
            scanCommonService.insertBillScan(userDto, bill, parentImage, images);
        } catch (Exception e) {
            log.error("单据补扫异常", e);
            throw new ElephantException(e);
        } finally {
            contextService.clear();
        }
    }

}
