package com.xforceplus.elephant.image.servicehandler;

import com.xforceplus.elephant.image.core.domain.label.LabelService;
import com.xforceplus.elephant.image.core.util.CommonEntityServiceHandler;
import com.xforceplus.tech.base.core.dispatcher.anno.QueryHandler;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.sdk.core.cmd.ConditionSearchCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleCreateCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleDeleteCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleQueryCmd;
import com.xforceplus.ultraman.sdk.core.cmd.SingleUpdateCmd;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.List;
import java.util.Map;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @Description
 * @Date 2020/3/18 10:40
 * @Author wanghao
 * @Version 1.0
 */
@Service
public class NewLabelService extends CommonEntityServiceHandler {

    @Autowired
    private LabelService labelService;

    @Override
    public Either<String, Map<String, Object>> singleQuery(SingleQueryCmd cmd) {
        return null;
    }

    @Override
    public Either<String, Integer> singleDelete(SingleDeleteCmd cmd) {
        return null;
    }

    @QueryHandler(condition = "msg.getMetaData().get('code').equals('label')")
    @Override
    public Either<String, Long> singleCreate(SingleCreateCmd cmd) {
        final String errMsg = checkLabel(cmd.getBody(), false);
        if (!("").equals(errMsg)) {
            return Either.left(errMsg);
        }

        return super.singleCreate(cmd);
    }

    @QueryHandler(condition = "msg.getMetaData().get('code').equals('label')")
    @Override
    public Either<String, Integer> singleUpdate(SingleUpdateCmd cmd) {
        final String errMsg = checkLabel(cmd.getBody(), true);
        if (!("").equals(errMsg)) {
            return Either.left(errMsg);
        }

        return super.singleUpdate(cmd);
    }

    @Override
    public Either<String, Tuple2<Integer, List<Map<String, Object>>>> conditionSearch(ConditionSearchCmd cmd) {
        return null;
    }

    /**
     * 校验标签内容
     *
     * @param body 对象
     * @return
     */
    private String checkLabel(Map<String, Object> body, boolean isEdit) {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆.");
        }
        final String lable_name = body.getOrDefault("label_name", "").toString();
        if ("".equals(lable_name)) {
            return "标签名称不可为空";
        }
        Long labelId = null;
        if (isEdit) {
            labelId = Long.valueOf(body.get("id").toString());
        }
        final boolean isExit = labelService.checkLabelName(authorizedUser.getTenantId(), authorizedUser.getId(), lable_name, labelId);
        if (isExit) {
            return "标签名称已存在";
        }
        return "";
    }

}
