package com.xforceplus.elephant.image.controller.batchnumberrule.process.autonomous;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.GetSerialNumberRequest;
import com.xforceplus.elephant.image.client.model.SaveSerialNumberRequest;
import com.xforceplus.elephant.image.controller.batchnumberrule.process.AbstractBatchNumberRuleProcess;
import com.xforceplus.elephant.image.core.facade.application.calculate.batchnumberrule.BatchNumberRuleFacade;
import com.xforceplus.elephant.image.core.repository.model.BatchNumberRuleEntity;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import javax.validation.ValidationException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class SaveSerialNumberForceProcess extends AbstractBatchNumberRuleProcess<SaveSerialNumberRequest, Boolean> {

    @Autowired
    private BatchNumberRuleFacade batchNumberRuleFacade;

    @Override
    protected void check(SaveSerialNumberRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getRuleCode(), "规则编号不能为空!");
        checkEmpty(request.getSerialNumber(), "流水号值不能为空!");
        try {
            Long.parseLong(request.getSerialNumber());
        } catch (NumberFormatException e) {
            throw new ValidationException("流水号值格式不正确");
        }
    }

    @Override
    protected CommonResponse<Boolean> process(SaveSerialNumberRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }

        //校验放在此处，主要是序列号规则对象是一定要查询的，减少重复查询
        final BatchNumberRuleEntity batchNumberRuleEntity = getBatchNumberRule(request.getRuleCode(), authorizedUser.getTenantId());
        checkAvailable(batchNumberRuleEntity);

        final String ruleDefine = batchNumberRuleEntity.getRuleDefine();
        final StringBuffer rulePre = new StringBuffer();
        //此处字段较少，为了维护方便做对象转换
        analysisRuleDefine(JSONObject.parseObject(JSONObject.toJSONString(request), GetSerialNumberRequest.class), ruleDefine, rulePre);

        final boolean result = batchNumberRuleFacade
            .submitSerialNumberForce(String.valueOf(authorizedUser.getTenantId()), request.getRuleCode(), rulePre.toString(), Long.parseLong(request.getSerialNumber()));

        return CommonResponse.ok("成功", result);
    }

}
