package com.xforceplus.elephant.image.controller.compare.billdata.process;

import static com.xforceplus.elephant.image.core.business.consts.Constants.TENANT_CODE;

import com.google.common.collect.Maps;
import com.xforceplus.elephant.basecommon.enums.bill.BackTypeEnum;
import com.xforceplus.elephant.basecommon.enums.cqp.bill.ExtStatusEnum;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.BackBaseBillRequest;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import com.xforceplus.elephant.image.core.domain.collaboration.CooperationService;
import com.xforceplus.elephant.image.core.domain.compare.bill.CompareBaseBillService;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.elephant.image.core.domain.compare.ticket.CompareTicketService;
import com.xforceplus.elephant.image.core.expand.compare.CompareBillImageTicketService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BackType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Deprecated
@Service
public class ComparePendingBackBaseBillProcess extends AbstractProcess<BackBaseBillRequest, Boolean> {

    @Autowired
    private CompareBillImageTicketService billImageTicketService;
    @Autowired
    private CompareImageService imageService;
    @Autowired
    private MQUtils rabbitmqUtils;
    @Autowired
    private CompareBaseBillService baseBillService;
    @Autowired
    private CompareTicketService compareTicketService;
    @Autowired
    private CooperationService cooperationService;

    @Override
    protected void check(BackBaseBillRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getBillCodes(), "billCodes不能为空");
    }

    @Override
    protected CommonResponse<Boolean> process(BackBaseBillRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final boolean backStatus = billImageTicketService.backBillInfoAndLog(request.getBillCodes(), BackType._0.getCode(), request.getBackReason(),
            request.getBackRemark(), authorizedUser.getId(), authorizedUser.getUsername(), authorizedUser.getTenantId());
        if (backStatus) {
            final List<String> billCodes = request.getBillCodes();
            billCodes.forEach(billCode -> {
                final BaseBill baseBill = baseBillService.selectBaseBillByCode(authorizedUser.getTenantId(), billCode);
                final List<Ticket> ticketEntities = compareTicketService.selectBaseTicketByBillCode(baseBill.getTenantId(),
                    baseBill.getBillCode());
                final List<Long> imageIds = ticketEntities.stream().map(Ticket::getImageId).collect(Collectors.toList());

                final Map<String, Object> paramMap = Maps.newHashMap();
                paramMap.put("back_status", YesNo._1.getCode());
                paramMap.put("back_time", System.currentTimeMillis());
                paramMap.put("back_type", BackTypeEnum.DEFAULT.getCode());
                paramMap.put("ticket_status", ExtStatusEnum.BACK.getCode());
                //更新Ticket
                updateTicket(paramMap, ticketEntities);
                if (ValidatorUtil.isNotEmpty(request.getBackRemark())) {
                    paramMap.put("back_remark", request.getBackRemark());
                }
                //推送pubsub
                final Map<String, Object> pushMap = Maps.newHashMap();
                pushMap.put("source", "收单单据退回");
                pushMap.put("tenantId", baseBill.getTenantId());
                pushMap.put("billCode", baseBill.getBillCode());
                pushMap.put("billTypeCode", baseBill.getBillTypeCode());
                final Map<String, Object> headers = new HashMap<>();
                headers.put(TENANT_CODE, authorizedUser.getTenantCode());
                rabbitmqUtils.sendByDirectExchange(MQEnum.RE_CHECK_BILL_TICKET_QUEUE, pushMap, headers);
                //推送发票pubsub
                imageIds.forEach(imageId -> {
                    cooperationService.syncTicket(authorizedUser.getTenantId(), authorizedUser.getTenantCode(), imageId, "收单单据退回");
                });
            });
            return CommonResponse.ok("成功", true);
        } else {
            return CommonResponse.failed("退回失败");
        }
    }

    private boolean updateTicket(Map<String, Object> paramMap, List<Ticket> ticketEntities) {
        if (paramMap.size() > 0) {
            return ticketEntities.stream().map(ticket ->
                                     compareTicketService.updateTicketByParam(ticket.getId(), EntityMeta.CompareTicket.code(), paramMap))
                                 .filter(count -> count > 0).count() == ticketEntities.size();
        }
        return false;
    }

}
