package com.xforceplus.elephant.image.controller.compare.billdata.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.help.NameUtils;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.CompareSaveBillH5Request;
import com.xforceplus.elephant.image.core.business.application.config.common.service.ConfigService;
import com.xforceplus.elephant.image.core.business.enums.DictEnum;
import com.xforceplus.elephant.image.core.domain.bill.BaseBillService;
import com.xforceplus.elephant.image.core.domain.compare.bill.CompareBaseBillService;
import com.xforceplus.elephant.image.core.expand.bean.BillRecogBean;
import com.xforceplus.elephant.image.core.expand.compare.CompareBillImageTicketService;
import com.xforceplus.elephant.image.core.util.RequestBuilder;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.CalculateStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageSource;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.IsPublic;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import java.util.List;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 移动端查询保存稽核单据
 *
 * @author rongying
 * @date 2021/5/10 15:28
 */
@Service
public class CompareSaveBillH5Process extends AbstractProcess<CompareSaveBillH5Request, JSONObject> {

    @Autowired
    private BaseBillService mainBaseBillService;
    @Autowired
    protected CompareBillImageTicketService billImageTicketService;
    @Autowired
    private CompareBaseBillService compareBaseBillService;

    @Autowired
    private ConfigService configService;

    @Override
    protected void check(CompareSaveBillH5Request request) throws ValidationException {
        checkEmpty(request.getBillCode(), "billCode不能为空");
    }

    @Override
    protected CommonResponse<JSONObject> process(CompareSaveBillH5Request request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        BaseBill billEntity = null;
        //稽核扫描需要匹配字段
        final List<String> matchFields = configService.selectDict(authorizedUser.getTenantId(), DictEnum.COMPARE_SCAN_MATCH_FIELDS.getCode(), String.class);
        //查询主数据是否存在, 是否到已锁定
        for (String field : matchFields) {
            final RequestBuilder builder = new RequestBuilder()
                .field("tenant_id", ConditionOp.eq, authorizedUser.getTenantId())
                .field(field, ConditionOp.eq, request.getBillCode())
                .pageSize(1);
            billEntity = mainBaseBillService.selectBaseBillByRequestBuilder(builder);
            if (billEntity != null) {
                break;
            }
        }
        if (ValidatorUtil.isEmpty(billEntity)) {
            return CommonResponse.failed(String.format("扫描单据，%s未查询到原始单据，请核实经办人是否已提交单据;", request.getBillCode()));
        }

        //查询稽核的单据是否存在
        BaseBill compareBillEntity = null;
        for (String field : matchFields) {
            final RequestBuilder builder = new RequestBuilder()
                .field("tenant_id", ConditionOp.eq, authorizedUser.getTenantId())
                .field(field, ConditionOp.eq, request.getBillCode())
                .pageSize(1);
            compareBillEntity = compareBaseBillService.selectBaseBillByRequestBuilder(builder);
            if (ValidatorUtil.isNotEmpty(compareBillEntity)) {
                return CommonResponse.ok("成功", BeanUtils.convertJSON(compareBillEntity));
            }
        }
        //保存单据
        final Long billId = saveBill(authorizedUser, billEntity);
        if (billId > 0) {
            compareBillEntity = compareBaseBillService.selectBillDataByBillId(billId);
            if (ValidatorUtil.isNotEmpty(compareBillEntity)) {
                return CommonResponse.ok("成功", BeanUtils.convertJSON(compareBillEntity));
            }
            return CommonResponse.failed("查询稽核单据失败");
        }
        return CommonResponse.failed("保存单据失败");
    }

    /**
     * 保存单据
     *
     * @param authorizedUser 用户
     * @param billEntity     billEntity
     * @return java.lang.Long
     * @author rongying
     * @date 2021/5/10 17:31
     */
    private Long saveBill(IAuthorizedUser authorizedUser, BaseBill billEntity) {
        //单据保存
        final BillRecogBean bean = new BillRecogBean();
        bean.setImageId(0L);
        bean.setTenantId(authorizedUser.getTenantId());
        bean.setIsPublic(IsPublic._1.getCode());
        bean.setScanUserId(authorizedUser.getId());
        bean.setScanUserName(authorizedUser.getUsername());
        bean.setBatchNo(Long.toString(System.currentTimeMillis()));
        //转换compare
        final String billTypeCode = NameUtils.firstLowerName(NameUtils.cameName("compare_" + billEntity.getBillTypeCode()));
        bean.setBillTypeCode(billTypeCode);
        final JSONObject discern = new JSONObject();
        discern.put(EntityMeta.CompareBaseBill.BILL_CODE.code(), billEntity.getBillCode());
        discern.put(EntityMeta.CompareBaseBill.CREATE_USER_CODE.code(), authorizedUser.getUserCode());
        discern.put(EntityMeta.CompareBaseBill.SYSTEM_SOURCE.code(), ImageSource._5.getCode());
        discern.put(EntityMeta.CompareBaseBill.PURCHASER_NAME.code(), billEntity.getPurchaserName());
        discern.put(EntityMeta.CompareBaseBill.PURCHASER_TAX_NO.code(), billEntity.getPurchaserTaxNo());
        discern.put(EntityMeta.CompareBaseBill.BILL_USE.code(), billEntity.getBillUse());
        discern.put(EntityMeta.CompareBaseBill.SETTLEMENT_NO.code(), billEntity.getSettlementNo());
        discern.put(EntityMeta.CompareBaseBill.CALCULATE_STATUS.code(), CalculateStatus._1.getCode());
        bean.setRecogInfo(discern);
        return billImageTicketService.insertOrUpdateBillRecogInfo(bean);
    }

}
